/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="specializeSuperType", label="Specialize Super Type", description="In the metamodel, the super type of a class is replaced by one of its sub classes. In the model, nothing is modified.")
public class SpecializeSuperType
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class whose super type is specialized")
    public EClass eClass;
    @EdaptParameter(description="The super type which is replaced")
    public EClass toReplace;
    @EdaptParameter(description="The sub class by which is replaced")
    public EClass replaceBy;

    @EdaptConstraint(restricts="toReplace", description="The super type to be replaced must be a super type of the class")
    public boolean checkToReplaceSuperType(EClass toReplace) {
        return this.eClass.getESuperTypes().contains((Object)toReplace);
    }

    @EdaptConstraint(description="The replacing super type must be a sub type of the replaced super type")
    public boolean checkToReplaceSubType() {
        return this.replaceBy.getEAllSuperTypes().contains((Object)this.toReplace);
    }

    @Override
    public void initialize(Metamodel metamodel) {
        if (this.eClass.getESuperTypes().size() == 1) {
            this.toReplace = (EClass)this.eClass.getESuperTypes().get(0);
            ArrayList subClasses = new ArrayList(metamodel.getESubTypes(this.toReplace));
            subClasses.remove(this.eClass);
            if (subClasses.size() == 1) {
                this.replaceBy = (EClass)subClasses.get(0);
            }
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        this.eClass.getESuperTypes().remove((Object)this.toReplace);
        this.eClass.getESuperTypes().add((Object)this.replaceBy);
    }
}

