/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectEcorePage
extends WizardPage {
    private Text text1;
    private Composite container;
    private Button browseWorkspaceBtn;
    private final String pluginId;
    private Button browsePackageRegistryBtn;
    private Object selectedContainer;

    public SelectEcorePage(String pageName) {
        super("Select Model");
        this.setTitle("Select Model");
        this.setDescription("Select a model file for the new View Model");
        this.pluginId = pageName;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label1 = new Label(this.container, 0);
        label1.setText("Selected Ecore:");
        this.text1 = new Text(this.container, 2052);
        this.text1.setText("");
        GridData gd = new GridData(768);
        this.text1.setLayoutData((Object)gd);
        Composite dummy = new Composite(this.container, 0);
        Composite btnsComposite = new Composite(this.container, 0);
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().create();
        gridLayout.numColumns = 2;
        btnsComposite.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btnsComposite);
        this.browseWorkspaceBtn = new Button(btnsComposite, 8);
        this.browseWorkspaceBtn.setText("Browse Workspace");
        this.browseWorkspaceBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = SelectEcorePage.this.getWorkspaceEcoreSelectionDialog();
                if (dialog.open() == 0) {
                    IFile selectedEcore = (IFile)dialog.getFirstResult();
                    SelectEcorePage.this.text1.setText(selectedEcore.getFullPath().toString());
                    SelectEcorePage.this.selectedContainer = selectedEcore;
                    SelectEcorePage.this.setPageComplete(SelectEcorePage.this.selectedContainer != null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browsePackageRegistryBtn = new Button(btnsComposite, 8);
        this.browsePackageRegistryBtn.setText("Browse Package Registry");
        this.browsePackageRegistryBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog selectRegisteredPackageDialog = SelectEcorePage.this.getPackageSelectionDialog();
                selectRegisteredPackageDialog.open();
                Object[] result = selectRegisteredPackageDialog.getResult();
                if (result == null) {
                    return;
                }
                String selectedEPackageURI = (String)result[0];
                SelectEcorePage.this.selectedContainer = EPackage.Registry.INSTANCE.getEPackage(selectedEPackageURI);
                SelectEcorePage.this.text1.setText(selectedEPackageURI);
                SelectEcorePage.this.setPageComplete(SelectEcorePage.this.selectedContainer != null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private ElementListSelectionDialog getPackageSelectionDialog() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
            }
        });
        dialog.setMultipleSelection(false);
        dialog.setTitle("Package Selection");
        dialog.setMessage("Select a package:");
        dialog.setElements(EcoreHelper.getDefaultPackageRegistryContents());
        return dialog;
    }

    private ElementTreeSelectionDialog getWorkspaceEcoreSelectionDialog() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                if (selection.length == 1 && selection[0] instanceof IFile && (file = (IFile)selection[0]).getFileExtension().equals("ecore")) {
                    return new Status(0, SelectEcorePage.this.pluginId, 0, null, null);
                }
                return new Status(4, SelectEcorePage.this.pluginId, 4, "Please Select a Model file", null);
            }
        });
        dialog.setTitle("Select Model");
        return dialog;
    }

    public String getText1() {
        return this.text1.getText();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void setSelectedContainer(Object object) {
        this.selectedContainer = object;
        this.setPageComplete(object != null);
        this.text1.setText(this.getContainerName());
    }

    public Object getSelectedContainer() {
        return this.selectedContainer;
    }

    private String getContainerName() {
        String containerName = "";
        if (this.selectedContainer != null) {
            if (EPackage.class.isInstance(this.selectedContainer)) {
                containerName = ((EPackage)EPackage.class.cast(this.selectedContainer)).getName();
            } else if (IFile.class.isInstance(this.selectedContainer)) {
                containerName = ((IFile)this.selectedContainer).getFullPath().toString();
            }
        }
        return containerName;
    }
}

