/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.bazaar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.BazaarContextFunction;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.bazaar.internal.BazaarImpl;
import org.eclipse.emfforms.bazaar.internal.ThreadSafeBazaar;

public interface Bazaar<T> {
    public void addVendor(Vendor<? extends T> var1);

    public void removeVendor(Vendor<? extends T> var1);

    public void addContextFunction(String var1, BazaarContextFunction var2);

    public T createProduct(BazaarContext var1);

    public List<T> createProducts(BazaarContext var1);

    public void setPriorityOverlapCallBack(PriorityOverlapCallBack<? super T> var1);

    public static final class Builder<T> {
        private final List<Vendor<? extends T>> vendors = new ArrayList<Vendor<? extends T>>();
        private final Map<String, BazaarContextFunction> contextFunctions = new HashMap<String, BazaarContextFunction>();
        private PriorityOverlapCallBack<? super T> overlapHandler;
        private boolean isThreadSafe;

        private Builder() {
        }

        private Builder(Collection<? extends Vendor<? extends T>> vendors) {
            this.vendors.addAll(vendors);
        }

        public static <T> Builder<T> empty() {
            return new Builder<T>();
        }

        public static <T> Builder<T> with(Collection<? extends Vendor<? extends T>> vendors) {
            return new Builder<T>(vendors);
        }

        public Builder<T> add(Vendor<? extends T> vendor) {
            this.vendors.add(vendor);
            return this;
        }

        public Builder<T> add(Vendor<? extends T> vendor1, Vendor<? extends T> vendor2, Vendor<? extends T> ... more) {
            this.vendors.add(vendor1);
            this.vendors.add(vendor2);
            if (more.length > 0) {
                this.vendors.addAll(Arrays.asList(more));
            }
            return this;
        }

        public Builder<T> addAll(Collection<? extends Vendor<? extends T>> vendors) {
            this.vendors.addAll(vendors);
            return this;
        }

        public Builder<T> addContextFunction(Class<?> type, BazaarContextFunction contextFunction) {
            return this.addContextFunction(type.getName(), contextFunction);
        }

        public Builder<T> addContextFunction(String key, BazaarContextFunction contextFunction) {
            this.contextFunctions.put(key, contextFunction);
            return this;
        }

        public Builder<T> onPriorityOverlap(PriorityOverlapCallBack<? super T> overlapHandler) {
            if (this.overlapHandler != null) {
                throw new IllegalStateException("overlap handler already set");
            }
            this.overlapHandler = overlapHandler;
            return this;
        }

        public Builder<T> threadSafe() {
            this.isThreadSafe = true;
            return this;
        }

        public Bazaar<T> build() {
            BazaarImpl<Object> result;
            if (this.isThreadSafe) {
                result = new ThreadSafeBazaar(this.vendors, this.contextFunctions, this.overlapHandler);
            } else {
                result = new BazaarImpl<Object>();
                for (Vendor<? extends T> vendor : this.vendors) {
                    result.addVendor(vendor);
                }
                for (Map.Entry entry : this.contextFunctions.entrySet()) {
                    result.addContextFunction((String)entry.getKey(), (BazaarContextFunction)entry.getValue());
                }
                if (this.overlapHandler != null) {
                    result.setPriorityOverlapCallBack(this.overlapHandler);
                }
            }
            return result;
        }
    }

    public static interface PriorityOverlapCallBack<T> {
        public void priorityOverlap(Vendor<? extends T> var1, Vendor<? extends T> var2);
    }
}

