/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.util.observer.ECPObserverBus;
import org.eclipse.emfforms.common.ServiceObjectTracker;
import org.osgi.framework.BundleContext;

public final class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.core";
    private static Activator instance;
    private static ServiceObjectTracker<ECPRepositoryManager> repositorManagerTracker;
    private static ServiceObjectTracker<ECPProjectManager> projectManagerTracker;
    private static ServiceObjectTracker<ECPProviderRegistry> providerRegistryTracker;
    private static ServiceObjectTracker<ECPObserverBus> observerBusTracker;

    public void start(BundleContext bundleContext) throws Exception {
        instance = this;
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (repositorManagerTracker != null) {
            repositorManagerTracker.dispose();
        }
        if (projectManagerTracker != null) {
            projectManagerTracker.dispose();
        }
        if (providerRegistryTracker != null) {
            providerRegistryTracker.dispose();
        }
        if (observerBusTracker != null) {
            observerBusTracker.dispose();
        }
        super.stop(bundleContext);
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void log(String message) {
        instance.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(int status, String message) {
        instance.getLog().log((IStatus)new Status(status, PLUGIN_ID, message));
    }

    private static void log(IStatus status) {
        instance.getLog().log(status);
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    private static IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            return coreException.getStatus();
        }
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(4, PLUGIN_ID, msg, t);
    }

    public static synchronized ECPProjectManager getECPProjectManager() {
        if (projectManagerTracker == null) {
            BundleContext bundleContext = instance.getBundle().getBundleContext();
            projectManagerTracker = new ServiceObjectTracker(bundleContext, ECPProjectManager.class);
        }
        return (ECPProjectManager)projectManagerTracker.getService();
    }

    public static synchronized ECPRepositoryManager getECPRepositoryManager() {
        if (repositorManagerTracker == null) {
            BundleContext bundleContext = instance.getBundle().getBundleContext();
            repositorManagerTracker = new ServiceObjectTracker(bundleContext, ECPRepositoryManager.class);
        }
        return (ECPRepositoryManager)repositorManagerTracker.getService();
    }

    public static synchronized ECPProviderRegistry getECPProviderRegistry() {
        if (providerRegistryTracker == null) {
            BundleContext bundleContext = instance.getBundle().getBundleContext();
            providerRegistryTracker = new ServiceObjectTracker(bundleContext, ECPProviderRegistry.class);
        }
        return (ECPProviderRegistry)providerRegistryTracker.getService();
    }

    public static synchronized ECPObserverBus getECPObserverBus() {
        if (observerBusTracker == null) {
            BundleContext bundleContext = instance.getBundle().getBundleContext();
            observerBusTracker = new ServiceObjectTracker(bundleContext, ECPObserverBus.class);
        }
        return (ECPObserverBus)observerBusTracker.getService();
    }
}

