/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ease.BreakException;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ISecurityCheck;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.security.ScriptUIAccess;
import org.eclipse.ease.service.EngineDescription;

public abstract class AbstractScriptEngine
extends Job
implements IScriptEngine {
    private final List<Script> fScheduledScripts = Collections.synchronizedList(new ArrayList());
    private final ListenerList<IExecutionListener> fExecutionListeners = new ListenerList();
    private PrintStream fOutputStream = null;
    private PrintStream fErrorStream = null;
    private InputStream fInputStream = null;
    private final ScriptStackTrace fStackTrace = new ScriptStackTrace();
    private EngineDescription fDescription;
    private boolean fSetupDone = false;
    private final Map<String, Object> fBufferedVariables = new HashMap<String, Object>();
    private boolean fCloseStreamsOnTerminate;
    private boolean fTerminated = false;
    private final HashMap<ISecurityCheck.ActionType, List<ISecurityCheck>> fSecurityChecks = new HashMap();
    private Object fExecutionRootFile;
    private ILaunch fLaunch = null;
    private IProgressMonitor fMonitor;

    public static IScriptEngine getCurrentScriptEngine() {
        if (Job.getJobManager().currentJob() instanceof IScriptEngine) {
            return (IScriptEngine)Job.getJobManager().currentJob();
        }
        return null;
    }

    public AbstractScriptEngine(String name) {
        super(name);
        this.setSystem(true);
    }

    @Override
    public EngineDescription getDescription() {
        return this.fDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScriptResult executeAsync(Object content) {
        Script script = content instanceof Script ? (Script)content : new Script(content);
        this.fScheduledScripts.add(script);
        AbstractScriptEngine abstractScriptEngine = this;
        synchronized (abstractScriptEngine) {
            this.notifyAll();
        }
        return script.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScriptResult executeSync(Object content) throws InterruptedException {
        ScriptResult result = this.executeAsync(content);
        if (this.getState() == 0) {
            this.schedule();
        }
        ScriptResult scriptResult = result;
        synchronized (scriptResult) {
            while (!result.isReady()) {
                result.wait();
            }
        }
        return result;
    }

    @Override
    public final Object inject(Object content) {
        return this.internalInject(content, false);
    }

    @Override
    public final Object injectUI(Object content) {
        return this.internalInject(content, true);
    }

    private final Object internalInject(Object content, boolean uiThread) {
        ScriptResult result = content instanceof Script ? this.inject((Script)content, false, uiThread) : this.inject(new Script(content), false, uiThread);
        if (result.hasException()) {
            if (result.getException() instanceof RuntimeException) {
                throw (RuntimeException)result.getException();
            }
            throw new RuntimeException(result.getException().getMessage(), result.getException());
        }
        return result.getResult();
    }

    private static String getFilename(Object file) {
        if (file instanceof IFile) {
            return ((IFile)file).toString();
        }
        if (file instanceof File) {
            return ((File)file).getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ScriptResult inject(Script script, boolean notifyListeners, boolean uiThread) {
        ScriptResult scriptResult = script.getResult();
        synchronized (scriptResult) {
            block27: {
                block29: {
                    try {
                        Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Executing script (" + script.getTitle() + "):", script.getCode());
                        String filename = AbstractScriptEngine.getFilename(script.getFile());
                        this.fStackTrace.add(0, new EaseDebugFrame(script, 0, 1, filename));
                        List<ISecurityCheck> securityChecks = this.fSecurityChecks.get((Object)ISecurityCheck.ActionType.INJECT_CODE);
                        if (securityChecks != null) {
                            for (ISecurityCheck check : securityChecks) {
                                if (check.doIt(ISecurityCheck.ActionType.INJECT_CODE, script, uiThread)) continue;
                                throw new ExitException();
                            }
                        }
                        if (notifyListeners) {
                            this.notifyExecutionListeners(script, 3);
                        } else {
                            this.notifyExecutionListeners(script, 5);
                        }
                        script.setResult(this.execute(script, script.getFile(), ((IScriptDebugFrame)this.fStackTrace.get(0)).getName(), uiThread));
                    }
                    catch (ExitException e) {
                        script.setResult(e.getCondition());
                        if (notifyListeners) {
                            this.notifyExecutionListeners(script, 4);
                        } else {
                            this.notifyExecutionListeners(script, 6);
                        }
                        if (!this.fStackTrace.isEmpty()) {
                            this.fStackTrace.remove(0);
                        }
                        break block27;
                    }
                    catch (BreakException e) {
                        script.setResult(e.getCondition());
                        break block27;
                    }
                    catch (Throwable e) {
                        block28: {
                            script.setException(e);
                            if (this.fStackTrace.size() <= 1) {
                                e.printStackTrace(this.getErrorStream());
                            }
                            if (notifyListeners) {
                                this.notifyExecutionListeners(script, 4);
                                break block28;
                            }
                            this.notifyExecutionListeners(script, 6);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        if (!this.fStackTrace.isEmpty()) {
                            this.fStackTrace.remove(0);
                        }
                        break block27;
                    }
                    {
                        finally {
                            if (notifyListeners) {
                                this.notifyExecutionListeners(script, 4);
                            } else {
                                this.notifyExecutionListeners(script, 6);
                            }
                            if (!this.fStackTrace.isEmpty()) {
                                this.fStackTrace.remove(0);
                            }
                        }
                    }
                    if (notifyListeners) {
                        this.notifyExecutionListeners(script, 4);
                        break block29;
                    }
                    this.notifyExecutionListeners(script, 6);
                }
                if (!this.fStackTrace.isEmpty()) {
                    this.fStackTrace.remove(0);
                }
            }
        }
        return script.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus returnStatus;
        block125: {
            List<Script> list;
            block121: {
                Throwable throwable2;
                block122: {
                    block113: {
                        List<Script> list2;
                        Throwable throwable2222;
                        block117: {
                            Throwable script3;
                            block118: {
                                block114: {
                                    List<Script> list3;
                                    block115: {
                                        Throwable script22;
                                        block116: {
                                            this.fMonitor = monitor;
                                            Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine started: " + this.getName());
                                            returnStatus = Status.OK_STATUS;
                                            this.addSecurityCheck(ISecurityCheck.ActionType.INJECT_CODE, ScriptUIAccess.getInstance());
                                            try {
                                                try {
                                                    this.setupEngine();
                                                    this.fSetupDone = true;
                                                    if (!this.isSystem()) {
                                                        new ScriptTerminator(monitor).schedule();
                                                    }
                                                    Iterator<Map.Entry<String, Object>> iterator = this.fBufferedVariables.entrySet().iterator();
                                                    while (true) {
                                                        if (!iterator.hasNext()) break;
                                                        Map.Entry<String, Object> entry = iterator.next();
                                                        this.setVariable(entry.getKey(), entry.getValue());
                                                    }
                                                    this.fBufferedVariables.clear();
                                                    this.fStackTrace.clear();
                                                    this.notifyExecutionListeners(null, 1);
                                                    while (true) {
                                                        Object piece;
                                                        block124: {
                                                            if (!monitor.isCanceled() && !this.isTerminated()) break block124;
                                                        }
                                                        if (!this.fScheduledScripts.isEmpty()) {
                                                            piece = this.fScheduledScripts.remove(0);
                                                            this.inject((Script)piece, true, false);
                                                            continue;
                                                        }
                                                        piece = this;
                                                        synchronized (piece) {
                                                            if (!this.isTerminated()) {
                                                                try {
                                                                    Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine idle: " + this.getName());
                                                                    this.wait();
                                                                }
                                                                catch (InterruptedException interruptedException) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                    }
                                                    returnStatus = !this.isTerminated() ? Status.OK_STATUS : Status.CANCEL_STATUS;
                                                    break block113;
                                                }
                                                catch (ScriptEngineException e) {
                                                    returnStatus = new Status(4, "org.eclipse.ease", "Could not setup script engine", (Throwable)e);
                                                    List<Script> list4 = this.fScheduledScripts;
                                                    synchronized (list4) {
                                                        list3 = this.fScheduledScripts.iterator();
                                                        while (true) {
                                                            if (!list3.hasNext()) {
                                                            }
                                                            Script script22 = list3.next();
                                                            script22.setException(new ExitException());
                                                        }
                                                    }
                                                }
                                                this.fScheduledScripts.clear();
                                                this.notifyExecutionListeners(null, 2);
                                            }
                                            catch (Throwable throwable2222) {
                                                List<Script> e = this.fScheduledScripts;
                                                synchronized (e) {
                                                    list2 = this.fScheduledScripts.iterator();
                                                    while (true) {
                                                        if (!list2.hasNext()) {
                                                            break block114;
                                                        }
                                                        Script script3 = list2.next();
                                                        script3.setException(new ExitException());
                                                    }
                                                }
                                            }
                                            try {
                                                try {
                                                    this.teardownEngine();
                                                    break block115;
                                                }
                                                catch (ScriptEngineException e) {
                                                    if (returnStatus.getSeverity() < 4) {
                                                        returnStatus = new Status(4, "org.eclipse.ease", "Could not teardown script engine", (Throwable)e);
                                                    }
                                                    this.fTerminated = true;
                                                    list3 = this;
                                                    synchronized (list3) {
                                                        this.notifyAll();
                                                    }
                                                    list3 = this.fScheduledScripts;
                                                    synchronized (list3) {
                                                        for (Script script4 : this.fScheduledScripts) {
                                                            script4.setException(new ExitException());
                                                        }
                                                        this.fScheduledScripts.clear();
                                                    }
                                                }
                                                this.closeStreams();
                                            }
                                            catch (Throwable script22) {
                                                this.fTerminated = true;
                                                list3 = this;
                                                synchronized (list3) {
                                                    this.notifyAll();
                                                }
                                                list3 = this.fScheduledScripts;
                                                synchronized (list3) {
                                                    for (Script script23 : this.fScheduledScripts) {
                                                        script23.setException(new ExitException());
                                                    }
                                                    this.fScheduledScripts.clear();
                                                    break block116;
                                                }
                                            }
                                            Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                                            break block125;
                                        }
                                        this.closeStreams();
                                        Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                                        throw script22;
                                    }
                                    this.fTerminated = true;
                                    list3 = this;
                                    synchronized (list3) {
                                        this.notifyAll();
                                    }
                                    list3 = this.fScheduledScripts;
                                    synchronized (list3) {
                                        for (Script script5 : this.fScheduledScripts) {
                                            script5.setException(new ExitException());
                                        }
                                        this.fScheduledScripts.clear();
                                    }
                                    this.closeStreams();
                                    Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                                    break block125;
                                }
                                this.fScheduledScripts.clear();
                                this.notifyExecutionListeners(null, 2);
                                try {
                                    try {
                                        this.teardownEngine();
                                        break block117;
                                    }
                                    catch (ScriptEngineException e) {
                                        if (returnStatus.getSeverity() < 4) {
                                            returnStatus = new Status(4, "org.eclipse.ease", "Could not teardown script engine", (Throwable)e);
                                        }
                                        this.fTerminated = true;
                                        list2 = this;
                                        synchronized (list2) {
                                            this.notifyAll();
                                        }
                                        list2 = this.fScheduledScripts;
                                        synchronized (list2) {
                                            Iterator<Script> iterator = this.fScheduledScripts.iterator();
                                            while (true) {
                                                if (!iterator.hasNext()) {
                                                    this.fScheduledScripts.clear();
                                                }
                                                Script script6 = iterator.next();
                                                script6.setException(new ExitException());
                                            }
                                        }
                                    }
                                    this.closeStreams();
                                }
                                catch (Throwable script3) {
                                    this.fTerminated = true;
                                    list2 = this;
                                    synchronized (list2) {
                                        this.notifyAll();
                                    }
                                    list2 = this.fScheduledScripts;
                                    synchronized (list2) {
                                        Iterator<Script> iterator = this.fScheduledScripts.iterator();
                                        while (true) {
                                            if (!iterator.hasNext()) {
                                                this.fScheduledScripts.clear();
                                                break block118;
                                            }
                                            Script script32 = iterator.next();
                                            script32.setException(new ExitException());
                                        }
                                    }
                                }
                                Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                                throw throwable2222;
                            }
                            this.closeStreams();
                            Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                            throw script3;
                        }
                        this.fTerminated = true;
                        list2 = this;
                        synchronized (list2) {
                            this.notifyAll();
                        }
                        list2 = this.fScheduledScripts;
                        synchronized (list2) {
                            Iterator<Script> iterator = this.fScheduledScripts.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    this.fScheduledScripts.clear();
                                    break;
                                }
                                Script script = iterator.next();
                                script.setException(new ExitException());
                            }
                        }
                        this.closeStreams();
                        Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                        throw throwable2222;
                    }
                    List<Script> e = this.fScheduledScripts;
                    synchronized (e) {
                        list = this.fScheduledScripts.iterator();
                        while (list.hasNext()) {
                            Script script = list.next();
                            script.setException(new ExitException());
                        }
                    }
                    this.fScheduledScripts.clear();
                    this.notifyExecutionListeners(null, 2);
                    try {
                        try {
                            this.teardownEngine();
                            break block121;
                        }
                        catch (ScriptEngineException e2) {
                            if (returnStatus.getSeverity() < 4) {
                                returnStatus = new Status(4, "org.eclipse.ease", "Could not teardown script engine", (Throwable)e2);
                            }
                            this.fTerminated = true;
                            list = this;
                            synchronized (list) {
                                this.notifyAll();
                            }
                            list = this.fScheduledScripts;
                            synchronized (list) {
                                Iterator<Script> iterator = this.fScheduledScripts.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        this.fScheduledScripts.clear();
                                    }
                                    Script script = iterator.next();
                                    script.setException(new ExitException());
                                }
                            }
                        }
                        this.closeStreams();
                    }
                    catch (Throwable throwable2) {
                        this.fTerminated = true;
                        list = this;
                        synchronized (list) {
                            this.notifyAll();
                        }
                        list = this.fScheduledScripts;
                        synchronized (list) {
                            Iterator<Script> iterator = this.fScheduledScripts.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    this.fScheduledScripts.clear();
                                    break block122;
                                }
                                Script script = iterator.next();
                                script.setException(new ExitException());
                            }
                        }
                    }
                    Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                    break block125;
                }
                this.closeStreams();
                Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                throw throwable2;
            }
            this.fTerminated = true;
            list = this;
            synchronized (list) {
                this.notifyAll();
            }
            list = this.fScheduledScripts;
            synchronized (list) {
                Iterator<Script> iterator = this.fScheduledScripts.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.fScheduledScripts.clear();
                        break;
                    }
                    Script script = iterator.next();
                    script.setException(new ExitException());
                }
            }
            this.closeStreams();
            Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
        }
        monitor.done();
        this.fMonitor = null;
        return returnStatus;
    }

    @Override
    public IProgressMonitor getMonitor() {
        return this.fMonitor;
    }

    private void closeStreams() {
        if (this.fCloseStreamsOnTerminate) {
            try {
                if (this.getInputStream() != null && !System.in.equals(this.getInputStream())) {
                    this.getInputStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.getOutputStream() != null && !System.out.equals(this.getOutputStream())) {
                    this.getOutputStream().close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getErrorStream() != null && !System.err.equals(this.getErrorStream())) {
                    this.getErrorStream().close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fOutputStream = null;
        this.fErrorStream = null;
        this.fInputStream = null;
    }

    @Override
    public void setCloseStreamsOnTerminate(boolean closeStreams) {
        this.fCloseStreamsOnTerminate = closeStreams;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.fOutputStream != null ? this.fOutputStream : System.out;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : (outputStream != null ? new PrintStream(outputStream) : null);
    }

    @Override
    public InputStream getInputStream() {
        return this.fInputStream != null ? this.fInputStream : System.in;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.fErrorStream != null ? this.fErrorStream : System.err;
    }

    @Override
    public void setErrorStream(OutputStream errorStream) {
        this.fErrorStream = errorStream instanceof PrintStream ? (PrintStream)errorStream : (errorStream != null ? new PrintStream(errorStream) : null);
    }

    protected boolean isTerminated() {
        return this.fScheduledScripts.isEmpty();
    }

    @Override
    public void addExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.add((Object)listener);
    }

    @Override
    public void removeExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.remove((Object)listener);
    }

    protected void notifyExecutionListeners(Script script, int status) {
        Object[] objectArray = this.fExecutionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IExecutionListener)listener).notify(this, script, status);
            ++n2;
        }
    }

    @Override
    public void terminate() {
        this.fScheduledScripts.clear();
        this.terminateCurrent();
        this.cancel();
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    public ScriptStackTrace getStackTrace() {
        return this.fStackTrace;
    }

    @Override
    public Object getExecutedFile() {
        for (IScriptDebugFrame trace : this.getStackTrace()) {
            Object file;
            if (trace.getType() != 1 || trace.getScript() == null || (file = trace.getScript().getFile()) == null) continue;
            return file;
        }
        return this.fExecutionRootFile;
    }

    public void setExecutionRootFile(Object executionRootFile) {
        this.fExecutionRootFile = executionRootFile;
    }

    public void setEngineDescription(EngineDescription description) {
        this.fDescription = description;
    }

    @Override
    public void setVariable(String name, Object content) {
        if (this.fSetupDone) {
            this.internalSetVariable(name, content);
        } else {
            this.fBufferedVariables.put(name, content);
        }
    }

    @Override
    public Object getVariable(String name) {
        if (this.fSetupDone) {
            return this.internalGetVariable(name);
        }
        return this.fBufferedVariables.get(name);
    }

    @Override
    public boolean hasVariable(String name) {
        if (this.fSetupDone) {
            return this.internalHasVariable(name);
        }
        return this.fBufferedVariables.containsKey(name);
    }

    @Override
    public Map<String, Object> getVariables() {
        if (this.fSetupDone) {
            return this.internalGetVariables();
        }
        return Collections.unmodifiableMap(this.fBufferedVariables);
    }

    public static final String[] extractArguments(String arguments) {
        ArrayList<String> args = new ArrayList<String>();
        if (arguments != null) {
            String[] tokens;
            String[] stringArray = tokens = arguments.split(",");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (!token.trim().isEmpty()) {
                    args.add(token.trim());
                }
                ++n2;
            }
        }
        return args.toArray(new String[args.size()]);
    }

    @Override
    public boolean isFinished() {
        return this.fTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join(long timeout) throws InterruptedException {
        AbstractScriptEngine abstractScriptEngine = this;
        synchronized (abstractScriptEngine) {
            if (!this.isFinished()) {
                this.wait(timeout);
            }
        }
    }

    @Override
    public void addSecurityCheck(ISecurityCheck.ActionType type, ISecurityCheck check) {
        if (!this.fSecurityChecks.containsKey((Object)type)) {
            this.fSecurityChecks.put(type, new ArrayList());
        }
        if (!this.fSecurityChecks.get((Object)type).contains(check)) {
            this.fSecurityChecks.get((Object)type).add(check);
        }
    }

    @Override
    public void removeSecurityCheck(ISecurityCheck check) {
        for (List<ISecurityCheck> entry : this.fSecurityChecks.values()) {
            entry.remove(check);
        }
    }

    protected List<Script> getScheduledScripts() {
        return this.fScheduledScripts;
    }

    public void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected abstract Object internalGetVariable(String var1);

    protected abstract Map<String, Object> internalGetVariables();

    protected abstract boolean internalHasVariable(String var1);

    protected abstract void internalSetVariable(String var1, Object var2);

    protected abstract void setupEngine() throws ScriptEngineException;

    protected abstract void teardownEngine() throws ScriptEngineException;

    protected abstract Object execute(Script var1, Object var2, String var3, boolean var4) throws Throwable;

    private class ScriptTerminator
    extends Job {
        private final IProgressMonitor fMonitor;

        public ScriptTerminator(IProgressMonitor monitor) {
            super("ScriptEngine termination guard");
            this.fMonitor = monitor;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.fMonitor.isCanceled()) {
                AbstractScriptEngine.this.terminate();
            } else {
                this.schedule(1000L);
            }
            return Status.OK_STATUS;
        }
    }
}

