/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileTrace
implements Iterable<Trace> {
    private final List<Trace> fTrace = new ArrayList<Trace>();

    public final void push(String url, int lineNumber, String content) {
        this.fTrace.add(0, new Trace(url, lineNumber, content));
    }

    @Override
    public final Iterator<Trace> iterator() {
        return this.fTrace.iterator();
    }

    public final List<Trace> getTrace() {
        return this.fTrace;
    }

    public void push(Object reference) {
        if (reference instanceof Trace) {
            this.fTrace.add(0, (Trace)reference);
        } else {
            this.fTrace.add(0, new Trace(reference));
        }
    }

    public Trace pop() {
        if (!this.fTrace.isEmpty()) {
            return this.fTrace.remove(0);
        }
        return null;
    }

    public Trace peek() {
        if (!this.fTrace.isEmpty()) {
            return this.fTrace.get(0);
        }
        return null;
    }

    public List<Object> getFileStack() {
        ArrayList<Object> files = new ArrayList<Object>();
        for (Trace trace : this.getTrace()) {
            Object file = trace.getFile();
            if (file instanceof IFile && ((IFile)file).exists()) {
                files.add(file);
                continue;
            }
            if (!(file instanceof File) || !((File)file).exists()) continue;
            files.add(file);
        }
        return files;
    }

    public Object getTopMostFile() {
        List<Object> list = this.getFileStack();
        return list.isEmpty() ? null : list.get(0);
    }

    public final class Trace {
        private int fLineNumber = 0;
        private String fUrl = null;
        private String fContent = "";

        private Trace(String url, int lineNumber, String content) {
            this.fUrl = url;
            this.fLineNumber = lineNumber;
            this.fContent = content;
        }

        public Trace(Object reference) {
            if (reference instanceof IFile) {
                this.fUrl = ((IFile)reference).getFullPath().toPortableString();
            } else if (reference instanceof File) {
                this.fUrl = ((File)reference).getAbsolutePath();
            } else if (reference != null) {
                this.fContent = reference.toString();
            }
        }

        public int getLineNumber() {
            return this.fLineNumber;
        }

        public Object getFile() {
            if (this.fUrl != null) {
                File file;
                try {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.fUrl));
                    if (file.exists()) {
                        return file;
                    }
                }
                catch (Exception exception) {}
                file = new File(this.fUrl);
                if (file.exists()) {
                    return file;
                }
            }
            return null;
        }

        public String getFileName() {
            return this.fUrl;
        }

        public void setLineNumber(int lineNumber) {
            this.fLineNumber = lineNumber;
        }

        public String getContent() {
            return this.fContent;
        }
    }
}

