/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.datasource.WrappedConnection;

public class WrappedDataSource
implements DataSource {
    private static final org.eclipse.dirigible.repository.logging.Logger logger = org.eclipse.dirigible.repository.logging.Logger.getLogger(WrappedDataSource.class);
    private static final int MAX_CONNECTIONS_COUNT = 8;
    private DataSource originalDataSource;
    private static final Collection<WrappedConnection> connections = Collections.synchronizedCollection(new ArrayList());
    private static final long WAIT_TIMEOUT = 500L;
    private static final int WAIT_COUNT = 5;
    public static final String SET_AUTO_COMMIT = "jdbcAutoCommit";

    public WrappedDataSource(DataSource originalDataSource) {
        this.originalDataSource = originalDataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.debug("entring - getConnection()");
        this.checkConnections();
        WrappedConnection wrappedConnection = new WrappedConnection(this.originalDataSource.getConnection(), this);
        this.addConnection(wrappedConnection);
        wrappedConnection.setAutoCommit(Boolean.parseBoolean(System.getProperty(SET_AUTO_COMMIT)));
        logger.debug("Connection acquired: " + wrappedConnection.hashCode() + " count: " + connections.size());
        logger.debug("exiting - getConnection()");
        return wrappedConnection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        logger.debug("entring - getConnection(String username, String password)");
        this.checkConnections();
        WrappedConnection wrappedConnection = new WrappedConnection(this.originalDataSource.getConnection(username, password), this);
        this.addConnection(wrappedConnection);
        wrappedConnection.setAutoCommit(Boolean.parseBoolean(System.getProperty(SET_AUTO_COMMIT)));
        logger.debug("Connection acquired: " + wrappedConnection.hashCode() + " count: " + connections.size());
        logger.debug("exiting - getConnection(String username, String password)");
        return wrappedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnections() throws SQLException {
        int i = 0;
        while (i < 5) {
            if (connections.size() == 8) {
                try {
                    WrappedDataSource wrappedDataSource = this;
                    synchronized (wrappedDataSource) {
                        this.wait(500L);
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                return;
            }
            ++i;
        }
        this.forceRelaseConnection();
    }

    private void forceRelaseConnection() throws SQLException {
        logger.debug("entring - forceRelaseConnection()");
        WrappedConnection oldestConnection = null;
        for (WrappedConnection connection : connections) {
            if (oldestConnection == null) {
                oldestConnection = connection;
            }
            if (oldestConnection.getTimeAcquired() >= connection.getTimeAcquired()) continue;
            oldestConnection = connection;
        }
        if (oldestConnection != null) {
            logger.error("Potential connection leak; victim connection is: " + oldestConnection.hashCode() + ", used (ms): " + oldestConnection.getTimeUsed());
            oldestConnection.close();
        }
        logger.debug("exiting - forceRelaseConnection()");
    }

    private void addConnection(WrappedConnection connection) {
        logger.debug("entring - addConnection()");
        connections.add(connection);
        logger.debug("exiting - addConnection()");
    }

    private void removeConnection(WrappedConnection connection) {
        logger.debug("entring - removeConnection()");
        connections.remove(connection);
        logger.debug("exiting - removeConnection()");
    }

    public void closedConnection(WrappedConnection wrappedConnection) {
        logger.debug("entring - closeConnection()");
        this.removeConnection(wrappedConnection);
        logger.debug("Connection released: " + wrappedConnection.hashCode() + " count: " + connections.size() + " time used: " + wrappedConnection.getTimeUsed() + "ms");
        logger.debug("exiting - closeConnection()");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        logger.debug("called - getLogWriter()");
        return this.originalDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        logger.debug("called - getLoginTimeout()");
        return this.originalDataSource.getLoginTimeout();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        logger.debug("called - isWrapperFor(Class<?> arg0)");
        return this.originalDataSource.isWrapperFor(arg0);
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        logger.debug("called - setLogWriter(PrintWriter arg0)");
        this.originalDataSource.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        logger.debug("called - setLoginTimeout(int arg0)");
        this.originalDataSource.setLoginTimeout(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        logger.debug("called - unwrap(Class<T> arg0)");
        return this.originalDataSource.unwrap(arg0);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        logger.debug("called - getParentLogger()");
        throw new SQLFeatureNotSupportedException();
    }
}

