/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridge;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.interactive.EMFInteractiveBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.Messages;
import org.eclipse.emf.diffmerge.bridge.interactive.util.ResourceUtil;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BridgeJob<SD>
extends Job {
    protected final SD _sourceDataSet;
    protected final URI _targetURI;
    protected ResourceSet _targetResourceSet;

    public BridgeJob(String jobName_p, SD sourceDataSet_p, URI targetURI_p) {
        super(jobName_p == null ? Messages.BridgeJob_DefaultName : jobName_p);
        this._sourceDataSet = sourceDataSet_p;
        this._targetURI = targetURI_p;
        this._targetResourceSet = this.initializeTargetResourceSet();
        this.setUser(true);
    }

    protected abstract EMFInteractiveBridge<SD, IEditableModelScope> getBridge();

    protected Resource getCreateTargetResource(URI uri_p) {
        ResourceSet rs = this.getTargetResourceSet();
        Resource result = ResourceUtil.getCreateResourceForUri(uri_p, rs);
        ResourceUtil.ensureLoaded(result);
        return result;
    }

    protected Resource getCreateTraceResource(URI uri_p) {
        return this.getCreateTargetResource(uri_p);
    }

    protected EditingDomain getTargetEditingDomain() {
        EditingDomain result = null;
        ResourceSet rs = this.getTargetResourceSet();
        result = AdapterFactoryEditingDomain.getEditingDomainFor((Object)rs);
        return result;
    }

    protected final ResourceSet getTargetResourceSet() {
        return this._targetResourceSet;
    }

    protected IEditableModelScope getTargetScope(Resource resource_p) {
        return new FragmentedModelScope(resource_p, false);
    }

    protected IBridgeTrace getTrace(Resource traceResource_p) {
        EObject root;
        IBridgeTrace result = null;
        if (!traceResource_p.getContents().isEmpty() && (root = (EObject)traceResource_p.getAllContents().next()) instanceof IBridgeTrace) {
            result = (IBridgeTrace)root;
        }
        return result;
    }

    protected URI getTraceURI() {
        return this._targetURI.appendFileExtension("bridgetraces");
    }

    protected void handleDeferrablePart(IIncrementalBridge<?, ?, ?> bridge_p, IIncrementalBridgeExecution execution_p, Resource targetResource_p, Resource traceResource_p, SubMonitor monitor_p) {
        monitor_p.subTask(Messages.BridgeJob_Step_InteractiveUpdate);
        DeferredBridgeExecutionAction deferrableAction = new DeferredBridgeExecutionAction(bridge_p, execution_p, targetResource_p, traceResource_p, this.isSaveAndCloseTarget(), monitor_p);
        this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
        this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)deferrableAction);
        if (this.isModal()) {
            deferrableAction.run();
            IStatus status = deferrableAction.getStatus();
            if (status != null && status.getSeverity() == 8) {
                final Display display = Display.getDefault();
                final boolean[] keepOpen = new boolean[1];
                display.syncExec(new Runnable(){

                    public void run() {
                        keepOpen[0] = MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)Messages.BridgeJob_KeepOpen_Title, (String)Messages.BridgeJob_KeepOpen_Message);
                    }
                });
                if (!keepOpen[0]) {
                    deferrableAction.dispose();
                }
            }
        }
    }

    protected ResourceSet initializeTargetResourceSet() {
        return new ResourceSetImpl();
    }

    protected boolean isModal() {
        boolean result = false;
        Boolean modalProp = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (modalProp != null) {
            result = modalProp;
        }
        return result;
    }

    protected boolean isSaveAndCloseTarget() {
        return true;
    }

    public IStatus run(IProgressMonitor monitor_p) {
        int workAmount = 10;
        SubMonitor monitor = monitor_p instanceof SubMonitor ? (SubMonitor)monitor_p : SubMonitor.convert((IProgressMonitor)monitor_p, (String)this.getName(), (int)10);
        monitor.subTask(Messages.BridgeJob_Step_SetUp);
        Resource targetResource = this.getCreateTargetResource(this._targetURI);
        URI traceURI = this.getTraceURI();
        Resource traceResource = this.getCreateTraceResource(traceURI);
        monitor.worked(1);
        monitor.subTask(Messages.BridgeJob_Step_Execution);
        final SubMonitor bridgeMonitor = monitor.newChild(8);
        final IBridgeTrace existingTrace = this.getTrace(traceResource);
        final IEditableModelScope targetScope = this.getTargetScope(targetResource);
        final EMFInteractiveBridge<SD, IEditableModelScope> bridge = this.getBridge();
        EditingDomain domain = this.getTargetEditingDomain();
        final IIncrementalBridgeExecution[] executionWrapper = new IIncrementalBridgeExecution[1];
        Runnable runnable = new Runnable(){

            public void run() {
                IIncrementalBridgeExecution localExecution;
                executionWrapper[0] = localExecution = bridge.executeOn(BridgeJob.this._sourceDataSet, targetScope, null, existingTrace, true, (IProgressMonitor)bridgeMonitor);
            }
        };
        MiscUtil.execute((EditingDomain)domain, (String)this.getName(), (Runnable)runnable, (boolean)true);
        IIncrementalBridgeExecution execution = executionWrapper[0];
        bridgeMonitor.done();
        this.handleDeferrablePart((IIncrementalBridge<?, ?, ?>)bridge, execution, targetResource, traceResource, monitor);
        return execution.getStatus();
    }

    protected static void setTrace(Resource traceResource_p, IBridgeTrace trace_p) {
        if (trace_p instanceof EObject) {
            traceResource_p.getContents().clear();
            traceResource_p.getContents().add((Object)((EObject)trace_p));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DeferredBridgeExecutionAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        private IIncrementalBridge<?, ?, ?> _bridge;
        private IIncrementalBridgeExecution _execution;
        private Resource _targetResource;
        private Resource _traceResource;
        private boolean _isSaveAndCloseTarget;
        private IStatus _status;
        private SubMonitor _monitor;

        public DeferredBridgeExecutionAction(IIncrementalBridge<?, ?, ?> bridge_p, IIncrementalBridgeExecution execution_p, Resource targetResource_p, Resource traceResource_p, boolean isSaveAndCloseTarget_p, SubMonitor monitor_p) {
            super(Messages.BridgeJob_ActionText);
            this._bridge = bridge_p;
            this._execution = execution_p;
            this._targetResource = targetResource_p;
            this._traceResource = traceResource_p;
            this._isSaveAndCloseTarget = isSaveAndCloseTarget_p;
            this._status = null;
            this._monitor = monitor_p;
        }

        public void dispose() {
            if (this._execution instanceof IIncrementalBridgeExecution.Editable) {
                ((IIncrementalBridgeExecution.Editable)this._execution).setInteractiveMergeData(null);
            }
            this._bridge = null;
            this._execution = null;
            this._targetResource = null;
            this._traceResource = null;
            this._monitor = null;
            this._status = null;
            this.setEnabled(false);
        }

        public IStatus getStatus() {
            return this._status;
        }

        public void run() {
            this._status = this._bridge.mergeInteractively(this._execution, (IProgressMonitor)this._monitor);
            if (this._status.isOK()) {
                this._monitor.subTask(Messages.BridgeJob_Step_Completion);
                this._monitor.worked(1);
                if (!this._execution.isActuallyIncremental()) {
                    BridgeJob.setTrace(this._traceResource, this._execution.getTrace());
                }
                if (!this._traceResource.getContents().isEmpty()) {
                    ResourceUtil.makePersistent(this._traceResource);
                }
                ResourceUtil.closeResource(this._traceResource);
                if (this._isSaveAndCloseTarget) {
                    ResourceUtil.makePersistent(this._targetResource);
                    ResourceUtil.closeResource(this._targetResource);
                }
                this._monitor.done();
                this.dispose();
            }
        }
    }
}

