/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers.jdbc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.DriverConnectionBase;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class JDBCConnection
extends DriverConnectionBase {
    public static final String TECHNOLOGY_ROOT_KEY = "jdbc";
    public static final String TECHNOLOGY_NAME = ConnectivityPlugin.getDefault().getResourceString("JDBCConnection.technologyName");
    private Version mTechVersion = Version.NULL_VERSION;
    private Version mServerVersion = Version.NULL_VERSION;
    private String mServerName;
    private boolean mHasDriverDefn = true;

    public JDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public void open() {
        if (this.mConnection != null) {
            this.close();
        }
        this.mConnection = null;
        this.mConnectException = null;
        boolean hasDriver = false;
        try {
            if (this.getDriverDefinition() != null) {
                hasDriver = true;
                super.open();
            }
        }
        catch (Exception e) {
            String exceptionCauseMsg;
            String string = exceptionCauseMsg = e.getCause() != null ? e.getCause().getMessage() : null;
            if (exceptionCauseMsg != null && (exceptionCauseMsg.equalsIgnoreCase("DriverConnectionBase.error.driverDefinitionNotSpecified") || exceptionCauseMsg.equalsIgnoreCase("DriverConnectionBase.error.driverDefinitionNotFound"))) {
                if (this.profileHasDriverDetails()) {
                    this.mHasDriverDefn = false;
                    ConnectivityPlugin.getDefault().logInfo(ConnectivityPlugin.getDefault().getResourceString("JDBCConnection.invalidDriverDefinition", new Object[]{exceptionCauseMsg, this.getDriverDefinitionId()}));
                } else {
                    e.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        if (!hasDriver) {
            this.internalCreateConnection();
        }
    }

    public String[] getJarListAsArray(String jarList) {
        if (jarList != null) {
            if (jarList.length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(jarList, IDriverMgmtConstants.PATH_DELIMITER);
            return paths;
        }
        return null;
    }

    public ClassLoader createClassLoader(ClassLoader parentCL) throws Exception {
        Properties props = this.getConnectionProfile().getBaseProperties();
        String jarList = props.getProperty("jarList");
        if (jarList == null || jarList.trim().length() == 0) {
            throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.jarListNotDefined"));
        }
        String[] jarStrings = this.getJarListAsArray(jarList);
        URL[] jars = new URL[jarStrings.length];
        int index = 0;
        int count = jars.length;
        while (index < count) {
            try {
                jars[index] = new File(jarStrings[index]).toURL();
            }
            catch (MalformedURLException e) {
                throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.invalidClassPath"), e);
            }
            ++index;
        }
        if (parentCL == null) {
            return URLClassLoader.newInstance(jars);
        }
        return URLClassLoader.newInstance(jars, parentCL);
    }

    private void internalCreateConnection() {
        try {
            ClassLoader parentCL = this.getParentClassLoader();
            ClassLoader driverCL = this.createClassLoader(parentCL);
            this.mConnection = this.createConnection(driverCL);
            if (this.mConnection == null) {
                throw new Exception(ConnectivityPlugin.getDefault().getResourceString("DriverConnectionBase.error.unknown"));
            }
            this.initVersions();
            this.updateVersionCache();
        }
        catch (Throwable t) {
            this.mConnectException = t;
            this.clearVersionCache();
        }
    }

    private boolean profileHasDriverDetails() {
        Properties props = this.getConnectionProfile().getBaseProperties();
        String driverClass = props.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        String jarList = props.getProperty("jarList");
        return driverClass != null && jarList != null;
    }

    protected Object createConnection(ClassLoader cl) throws Throwable {
        Properties props = this.getConnectionProfile().getBaseProperties();
        Properties connectionProps = new Properties();
        String driverClass = null;
        driverClass = this.mHasDriverDefn ? this.getDriverDefinition().getProperty("org.eclipse.datatools.connectivity.db.driverClass") : props.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        String connectURL = props.getProperty("org.eclipse.datatools.connectivity.db.URL");
        String uid = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        String pwd = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        String nameValuePairs = props.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        String propDelim = ",";
        if (uid != null) {
            connectionProps.setProperty("user", uid);
        }
        if (pwd != null) {
            connectionProps.setProperty("password", pwd);
        }
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            String[] pairs = this.parseString(nameValuePairs, ",");
            String addPairs = "";
            int i = 0;
            while (i < pairs.length) {
                String[] namevalue = this.parseString(pairs[i], "=");
                connectionProps.setProperty(namevalue[0], namevalue[1]);
                if (i == 0 || i < pairs.length - 1) {
                    addPairs = String.valueOf(addPairs) + propDelim;
                }
                addPairs = String.valueOf(addPairs) + pairs[i];
                ++i;
            }
        }
        Driver jdbcDriver = (Driver)cl.loadClass(driverClass).newInstance();
        return jdbcDriver.connect(connectURL, connectionProps);
    }

    public void close() {
        Connection connection = (Connection)this.getRawConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getProviderName() {
        return this.mServerName;
    }

    public Version getProviderVersion() {
        return this.mServerVersion;
    }

    protected String getTechnologyRootKey() {
        return TECHNOLOGY_ROOT_KEY;
    }

    public String getTechnologyName() {
        return TECHNOLOGY_NAME;
    }

    public Version getTechnologyVersion() {
        return this.mTechVersion;
    }

    protected void initVersions() {
        try {
            DatabaseMetaData dbmd = ((Connection)this.getRawConnection()).getMetaData();
            try {
                this.mServerName = dbmd.getDatabaseProductName();
            }
            catch (Throwable throwable) {}
            try {
                String[] versionComps;
                String versionString = dbmd.getDatabaseProductVersion();
                if (versionString.indexOf(47) > 0 && (versionComps = versionString.split("/", 4)).length > 2) {
                    versionString = versionComps[1];
                    if (versionComps.length > 3) {
                        versionString = String.valueOf(versionString) + '.' + (versionComps[2].startsWith("EBF") ? versionComps[2].substring(3).trim() : versionComps[2]);
                    }
                    if (versionComps[0].length() > 0 && !versionComps[0].equals(this.mServerName)) {
                        this.mServerName = versionComps[0];
                    }
                }
                this.mServerVersion = Version.valueOf(versionString);
            }
            catch (Throwable throwable) {}
            try {
                this.mTechVersion = new Version(dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion(), 0, new String());
            }
            catch (Throwable throwable) {}
        }
        catch (SQLException sQLException) {}
    }

    protected String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }
}

