/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import org.eclipse.datatools.sqltools.sqleditor.internal.matching.AbstractPairMatcher;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.GenericSQLMatchingPairs;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.GenericSQLPairMatcher;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class MatchingPairPainter
implements IPainter,
PaintListener {
    private boolean fIsActive = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private Color fColor;
    private IPaintPositionManager fPaintPositionManager;
    private Position fPairPosition = new Position(0, 0);
    private int fAnchor;
    private AbstractPairMatcher fPairMatcher;

    public MatchingPairPainter(ISourceViewer sourceViewer, ICharacterPairMatcher matcher) {
        this.fPairMatcher = matcher instanceof AbstractPairMatcher ? (AbstractPairMatcher)matcher : new GenericSQLPairMatcher(GenericSQLMatchingPairs.getInstance());
        this.fSourceViewer = sourceViewer;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (this.fPaintPositionManager != null) {
                this.fPaintPositionManager.unmanagePosition(this.fPairPosition);
            }
            if (redraw) {
                this.handleDrawRequest(null);
            }
        }
    }

    public void dispose() {
        if (this.fPairMatcher != null) {
            this.fPairMatcher.clear();
            this.fPairMatcher = null;
        }
        this.fColor = null;
    }

    public void paint(int reason) {
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        Point selection = this.fSourceViewer.getSelectedRange();
        if (selection.y > 0) {
            this.deactivate(true);
            return;
        }
        IRegion pair = this.fPairMatcher.match(document, selection.x);
        if (pair == null) {
            this.deactivate(true);
            this.redraw();
            return;
        }
        if (this.fIsActive) {
            if (16 == reason) {
                this.handleDrawRequest(null);
            } else if (pair.getOffset() != this.fPairPosition.getOffset() || pair.getLength() != this.fPairPosition.getLength() || this.fPairMatcher.getAnchor() != this.fAnchor) {
                this.handleDrawRequest(null);
                this.fPairPosition.isDeleted = false;
                this.fPairPosition.offset = pair.getOffset();
                this.fPairPosition.length = pair.getLength();
                this.fAnchor = this.fPairMatcher.getAnchor();
                this.handleDrawRequest(null);
            }
        } else {
            this.fIsActive = true;
            this.fPairPosition.isDeleted = false;
            this.fPairPosition.offset = pair.getOffset();
            this.fPairPosition.length = pair.getLength();
            this.fAnchor = this.fPairMatcher.getAnchor();
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.fPaintPositionManager.managePosition(this.fPairPosition);
            this.handleDrawRequest(null);
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
        this.fPaintPositionManager = manager;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        if (this.fPairPosition.isDeleted) {
            return;
        }
        int offset = this.fPairPosition.getOffset();
        int length = this.fPairPosition.getLength();
        if (length < 1) {
            return;
        }
        IDocument document = this.fSourceViewer.getDocument();
        Point selection = this.fSourceViewer.getSelectedRange();
        IRegion pair = this.fPairMatcher.match(document, selection.x);
        if (pair == null) {
            return;
        }
        offset = 0;
        length = this.fPairMatcher.getMatchingTokenLength();
        this.fAnchor = this.fPairMatcher.getAnchor();
        offset = this.fAnchor == 0 ? pair.getOffset() : pair.getOffset() + pair.getLength() - length;
        if (offset >= document.get().length()) {
            return;
        }
        this.draw(gc, offset, length);
    }

    private void draw(GC gc, int offset, int length) {
        if (gc != null) {
            Rectangle bounds;
            gc.setForeground(this.fColor);
            if (length > 0) {
                bounds = this.fTextWidget.getTextBounds(offset, offset + length - 1);
            } else {
                Point loc = this.fTextWidget.getLocationAtOffset(offset);
                bounds = new Rectangle(loc.x, loc.y, 1, this.fTextWidget.getLineHeight(offset));
            }
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        } else {
            this.redraw();
        }
    }

    private void redraw() {
        if (this.fTextWidget == null) {
            return;
        }
        this.fTextWidget.redraw();
    }

    protected AbstractPairMatcher getFPairMatcher() {
        return this.fPairMatcher;
    }

    protected void setFPairMatcher(AbstractPairMatcher pairMatcher) {
        this.fPairMatcher = pairMatcher;
    }
}

