/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.reader;

import java.io.InputStream;
import org.eclipse.tm4e.core.internal.grammar.RawCaptures;
import org.eclipse.tm4e.core.internal.grammar.RawGrammar;
import org.eclipse.tm4e.core.internal.grammar.RawRepository;
import org.eclipse.tm4e.core.internal.grammar.RawRule;
import org.eclipse.tm4e.core.internal.parser.PListParser;
import org.eclipse.tm4e.core.internal.parser.PListParserJSON;
import org.eclipse.tm4e.core.internal.parser.PListParserXML;
import org.eclipse.tm4e.core.internal.parser.PListParserYAML;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;

public final class GrammarReader {
    public static final PropertySettable.Factory<PListPath> OBJECT_FACTORY = path -> {
        if (path.size() == 0) {
            return new RawGrammar();
        }
        switch (path.last()) {
            case "repository": {
                return new RawRepository();
            }
            case "whileCaptures": 
            case "endCaptures": 
            case "captures": 
            case "beginCaptures": {
                return new RawCaptures();
            }
        }
        return new RawRule();
    };
    private static final PListParser<RawGrammar> JSON_PARSER = new PListParserJSON<RawGrammar>(OBJECT_FACTORY);
    private static final PListParser<RawGrammar> XML_PARSER = new PListParserXML<RawGrammar>(OBJECT_FACTORY);
    private static final PListParser<RawGrammar> YAML_PARSER = new PListParserYAML<RawGrammar>(OBJECT_FACTORY);

    public static IRawGrammar readGrammarSync(String filePath, InputStream in) throws Exception {
        return GrammarReader.getGrammarParser(filePath).parse(in);
    }

    private static PListParser<RawGrammar> getGrammarParser(String filePath) {
        String extension;
        switch (extension = filePath.substring(filePath.lastIndexOf(46) + 1).trim().toLowerCase()) {
            case "json": {
                return JSON_PARSER;
            }
            case "yml": 
            case "yaml": 
            case "yaml-tmlanguage": {
                return YAML_PARSER;
            }
        }
        return XML_PARSER;
    }

    private GrammarReader() {
    }
}

