/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.debug.core.IBinaryStreamListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.core.model.IBinaryStreamsProxy;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class NullStreamsProxy
implements IBinaryStreamsProxy {
    private NullStreamMonitor outputStreamMonitor;
    private NullStreamMonitor errorStreamMonitor;

    public NullStreamsProxy(Process process) {
        this.outputStreamMonitor = new NullStreamMonitor(process.getInputStream());
        this.errorStreamMonitor = new NullStreamMonitor(process.getErrorStream());
    }

    @Override
    public void closeInputStream() throws IOException {
    }

    @Override
    public IStreamMonitor getErrorStreamMonitor() {
        return this.errorStreamMonitor;
    }

    @Override
    public IStreamMonitor getOutputStreamMonitor() {
        return this.outputStreamMonitor;
    }

    @Override
    public void write(String input) throws IOException {
    }

    @Override
    public IBinaryStreamMonitor getBinaryErrorStreamMonitor() {
        return this.errorStreamMonitor;
    }

    @Override
    public IBinaryStreamMonitor getBinaryOutputStreamMonitor() {
        return this.outputStreamMonitor;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
    }

    private class NullStreamMonitor
    implements IBinaryStreamMonitor {
        private InputStream fStream;

        public NullStreamMonitor(InputStream stream) {
            this.fStream = stream;
            this.startReaderThread();
        }

        private void startReaderThread() {
            Thread thread = new Thread(() -> {
                byte[] bytes = new byte[1024];
                try {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (InputStream stream = this.fStream;){
                        while (stream.read(bytes) >= 0) {
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }, DebugCoreMessages.NullStreamsProxy_0);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void addListener(IStreamListener listener) {
        }

        @Override
        public String getContents() {
            return "";
        }

        @Override
        public void flushContents() {
        }

        @Override
        public void setBuffered(boolean buffer) {
        }

        @Override
        public boolean isBuffered() {
            return false;
        }

        @Override
        public void removeListener(IStreamListener listener) {
        }

        @Override
        public void addBinaryListener(IBinaryStreamListener listener) {
        }

        @Override
        public byte[] getData() {
            return new byte[0];
        }

        @Override
        public void removeBinaryListener(IBinaryStreamListener listener) {
        }
    }
}

