/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.ImplementedBy;

@ImplementedBy(value=DefaultImpl.class)
public interface ILanguageServerShutdownAndExitHandler {
    public void exit();

    public void shutdown();

    public static class DefaultImpl
    implements ILanguageServerShutdownAndExitHandler {
        private boolean hasShutdownBeenCalled = false;

        @Override
        public void exit() {
            if (this.hasShutdownBeenCalled) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }

        @Override
        public void shutdown() {
            this.hasShutdownBeenCalled = true;
        }
    }

    public static class NullImpl
    implements ILanguageServerShutdownAndExitHandler {
        @Override
        public void exit() {
        }

        @Override
        public void shutdown() {
        }
    }
}

