/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.petrinet.PTransition;
import org.eclipse.comma.petrinet.Token;

class Place {
    final String name;
    final PPlaceType type;
    final State state;
    final StateMachine machine;
    private final List<Token> tokens = new ArrayList<Token>();

    private Place(String name, PPlaceType type, StateMachine machine, State state) {
        this.name = name;
        this.type = type;
        this.state = state;
        this.machine = machine;
        assert (this.type == PPlaceType.VARIABLES || this.type == PPlaceType.PARAMETERS || this.machine != null);
    }

    private static String name(String prefix, StateMachine machine, String name) {
        String machineName = "";
        if (((Interface)machine.eContainer()).getMachines().size() > 1) {
            machineName = "_" + machine.getName();
        }
        return String.format("%s%s_%s", prefix, machineName, name);
    }

    static Place forState(StateMachine machine, State state) {
        return new Place(Place.name("S", machine, state.getName()), PPlaceType.STATE, machine, state);
    }

    static Place forVariables() {
        return new Place("V", PPlaceType.VARIABLES, null, null);
    }

    static Place forTransition(StateMachine machine, State state, Transition transition) {
        String key;
        String name = Place.name("T", machine, state.getName());
        String transitionName = "NonTriggered";
        if (transition instanceof TriggeredTransition) {
            transitionName = String.valueOf(((TriggeredTransition)transition).getTrigger().getName()) + "()";
        }
        if ((key = Integer.toString(state.getTransitions().indexOf((Object)transition))).equals("-1")) {
            InAllStatesBlock allState = machine.getInAllStates().stream().filter(s -> s.getTransitions().contains((Object)transition)).findFirst().get();
            key = String.format("ias%d.%d", machine.getInAllStates().indexOf((Object)allState), allState.getTransitions().indexOf((Object)transition));
        }
        name = String.format("%s_%s_%s", name, key, transitionName);
        return new Place(name, PPlaceType.TRANSITION, machine, state);
    }

    static Place forClause(Place transitionPlace, Clause clause) {
        int index = ((Transition)clause.eContainer()).getClauses().indexOf((Object)clause);
        String name = String.format("C%s_%d_0", transitionPlace.name.substring(1), index);
        return new Place(name, PPlaceType.CLAUSE, transitionPlace.machine, transitionPlace.state);
    }

    static Place forParameters(PTransition transition) {
        String name = String.format("P_%s", transition.eventName(true));
        return new Place(name, PPlaceType.PARAMETERS, null, null);
    }

    static Place forParameters(PTransition transition, State state) {
        String name = String.format("P_%s_%s", state.getName(), transition.eventName(true));
        return new Place(name, PPlaceType.PARAMETERS, null, null);
    }

    static Place forClause(Place precedingPlace, String key) {
        Pattern p = Pattern.compile("^(.*)_\\d+(_join|_split|_quit)?$");
        Matcher m = p.matcher(precedingPlace.name);
        if (precedingPlace.type != PPlaceType.CLAUSE || !m.find()) {
            throw new RuntimeException("Not allowed");
        }
        String name = String.format("%s_%s", m.group(1), key);
        return new Place(name, PPlaceType.CLAUSE, precedingPlace.machine, precedingPlace.state);
    }

    static Place forClauseNest(Place precedingPlace, String key) {
        assert (precedingPlace.type == PPlaceType.CLAUSE) : "Not allowed";
        String name = String.format("%s_%s", precedingPlace.name, key);
        return new Place(name, PPlaceType.CLAUSE, precedingPlace.machine, precedingPlace.state);
    }

    boolean isInitial() {
        return this.type == PPlaceType.STATE && this.state.isInitial();
    }

    void addToken(Token token) {
        this.tokens.add(token);
    }

    String toPython(Interface itf) {
        String token = "";
        if (!this.tokens.isEmpty()) {
            token = String.format(", [%s]", this.tokens.stream().map(t -> t.toPython()).collect(Collectors.joining(", ")));
        }
        String meta = String.format("'type': '%s', 'interface': '%s'", this.type.toString().toLowerCase(), itf.getName());
        if (this.machine != null) {
            meta = String.valueOf(meta) + String.format(", 'machine': '%s'", this.machine.getName());
        }
        if (this.state != null) {
            meta = String.valueOf(meta) + String.format(", 'state': '%s'", this.state.getName());
        }
        return String.format("add_place(Place('%s'%s), {%s})\n", this.name, token, meta);
    }

    static enum PPlaceType {
        PARAMETERS,
        STATE,
        TRANSITION,
        CLAUSE,
        VARIABLES;

    }
}

