/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.expressions.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum QUANTIFIER implements Enumerator
{
    EXISTS(0, "EXISTS", "exists"),
    FORALL(1, "FORALL", "forAll"),
    DELETE(2, "DELETE", "delete");

    public static final int EXISTS_VALUE = 0;
    public static final int FORALL_VALUE = 1;
    public static final int DELETE_VALUE = 2;
    private static final QUANTIFIER[] VALUES_ARRAY;
    public static final List<QUANTIFIER> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new QUANTIFIER[]{EXISTS, FORALL, DELETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static QUANTIFIER get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QUANTIFIER result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QUANTIFIER getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QUANTIFIER result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QUANTIFIER get(int value) {
        switch (value) {
            case 0: {
                return EXISTS;
            }
            case 1: {
                return FORALL;
            }
            case 2: {
                return DELETE;
            }
        }
        return null;
    }

    private QUANTIFIER(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

