/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.StandardsReader;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.model.IRetentionIndexEntry;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.ui.wizards.ChromatogramWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.IChromatogramWizardElements;

public class RetentionIndexWizardElements
extends ChromatogramWizardElements
implements IRetentionIndexWizardElements {
    private List<IRetentionIndexEntry> retentionIndexEntries;
    private String[] availableStandards;
    private boolean useExistingRetentionIndexFile;
    private String filterPathRetentionIndexFile;
    private String pathRetentionIndexFile;
    private boolean useMassSpectrometryData;
    private IChromatogramWizardElements chromatogramWizardElementsMSD;
    private IChromatogramWizardElements chromatogramWizardElementsCSD;
    private String startIndexName;
    private String stopIndexName;
    private boolean useAlreadyDetectedPeaks;
    private IChromatogramSelectionMSD chromatogramSelectionMSD;
    private IChromatogramSelectionCSD chromatogramSelectionCSD;
    private List<IRetentionIndexEntry> extractedRetentionIndexEntries;
    private boolean retentionIndexDataIsValidated;

    public RetentionIndexWizardElements() {
        this.initialize();
    }

    @Override
    public float getRetentionIndex(String name) {
        float retentionIndex = 0.0f;
        for (IRetentionIndexEntry retentionIndexEntry : this.retentionIndexEntries) {
            if (!retentionIndexEntry.getName().equals(name)) continue;
            return retentionIndexEntry.getRetentionIndex();
        }
        return retentionIndex;
    }

    @Override
    public List<IRetentionIndexEntry> getSelectedRetentionIndexEntries() {
        ArrayList<IRetentionIndexEntry> selectedRetentionIndexEntries = new ArrayList<IRetentionIndexEntry>();
        boolean addIndex = false;
        for (IRetentionIndexEntry retentionIndexEntry : this.retentionIndexEntries) {
            String name = retentionIndexEntry.getName();
            if (name.equals(this.startIndexName)) {
                addIndex = true;
            } else if (name.equals(this.stopIndexName)) {
                selectedRetentionIndexEntries.add(retentionIndexEntry);
                addIndex = false;
            }
            if (!addIndex) continue;
            selectedRetentionIndexEntries.add(retentionIndexEntry);
        }
        return selectedRetentionIndexEntries;
    }

    @Override
    public String[] getAvailableStandards() {
        return this.availableStandards;
    }

    @Override
    public boolean isUseExistingRetentionIndexFile() {
        return this.useExistingRetentionIndexFile;
    }

    @Override
    public void setUseExistingRetentionIndexFile(boolean useExistingRetentionIndexFile) {
        this.useExistingRetentionIndexFile = useExistingRetentionIndexFile;
    }

    @Override
    public String getFilterPathCalibrationFile() {
        return this.filterPathRetentionIndexFile;
    }

    @Override
    public void setFilterPathCalibrationFile(String filterPathCalibrationFile) {
        this.filterPathRetentionIndexFile = filterPathCalibrationFile;
    }

    @Override
    public String getPathRetentionIndexFile() {
        return this.pathRetentionIndexFile;
    }

    @Override
    public void setPathRetentionIndexFile(String pathRetentionIndexFile) {
        this.pathRetentionIndexFile = pathRetentionIndexFile;
    }

    @Override
    public boolean isUseMassSpectrometryData() {
        return this.useMassSpectrometryData;
    }

    @Override
    public void setUseMassSpectrometryData(boolean useMassSpectrometryData) {
        this.useMassSpectrometryData = useMassSpectrometryData;
    }

    @Override
    public IChromatogramWizardElements getChromatogramWizardElementsMSD() {
        return this.chromatogramWizardElementsMSD;
    }

    @Override
    public IChromatogramWizardElements getChromatogramWizardElementsCSD() {
        return this.chromatogramWizardElementsCSD;
    }

    @Override
    public String getStartIndexName() {
        return this.startIndexName;
    }

    @Override
    public void setStartIndexName(String startIndexName) {
        this.startIndexName = startIndexName;
    }

    @Override
    public String getStopIndexName() {
        return this.stopIndexName;
    }

    @Override
    public void setStopIndexName(String stopIndexName) {
        this.stopIndexName = stopIndexName;
    }

    @Override
    public boolean isUseAlreadyDetectedPeaks() {
        return this.useAlreadyDetectedPeaks;
    }

    @Override
    public void setUseAlreadyDetectedPeaks(boolean useAlreadyDetectedPeaks) {
        this.useAlreadyDetectedPeaks = useAlreadyDetectedPeaks;
    }

    @Override
    public IChromatogramSelectionMSD getChromatogramSelectionMSD() {
        return this.chromatogramSelectionMSD;
    }

    @Override
    public void setChromatogramSelectionMSD(IChromatogramSelectionMSD chromatogramSelectionMSD) {
        this.chromatogramSelectionMSD = chromatogramSelectionMSD;
    }

    @Override
    public IChromatogramSelectionCSD getChromatogramSelectionCSD() {
        return this.chromatogramSelectionCSD;
    }

    @Override
    public void setChromatogramSelectionCSD(IChromatogramSelectionCSD chromatogramSelectionCSD) {
        this.chromatogramSelectionCSD = chromatogramSelectionCSD;
    }

    @Override
    public List<IRetentionIndexEntry> getExtractedRetentionIndexEntries() {
        return this.extractedRetentionIndexEntries;
    }

    @Override
    public void setExtractedRetentionIndexEntries(List<IRetentionIndexEntry> extractedRetentionIndexEntries) {
        this.extractedRetentionIndexEntries = extractedRetentionIndexEntries;
    }

    @Override
    public boolean isRetentionIndexDataValidated() {
        return this.retentionIndexDataIsValidated;
    }

    @Override
    public void setRetentionIndexDataIsValidated(boolean retentionIndexDataIsValidated) {
        this.retentionIndexDataIsValidated = retentionIndexDataIsValidated;
    }

    private void initialize() {
        StandardsReader standardsReader = new StandardsReader();
        this.retentionIndexEntries = standardsReader.getStandardsList();
        int size = this.retentionIndexEntries.size();
        this.availableStandards = new String[size];
        int i = 0;
        while (i < size) {
            this.availableStandards[i] = this.retentionIndexEntries.get(i).getName();
            ++i;
        }
        this.useExistingRetentionIndexFile = false;
        this.useMassSpectrometryData = true;
        this.chromatogramWizardElementsMSD = new ChromatogramWizardElements();
        this.chromatogramWizardElementsCSD = new ChromatogramWizardElements();
        this.pathRetentionIndexFile = "";
        this.startIndexName = "";
        this.stopIndexName = "";
        this.useAlreadyDetectedPeaks = false;
        this.extractedRetentionIndexEntries = new ArrayList<IRetentionIndexEntry>();
        this.retentionIndexDataIsValidated = false;
    }
}

