/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.internal.runnables.ImportChromatogramRunnable;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.PeakTableViewerUI;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.SelectedPeakChromatogramUI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PagePeakSelectionMSD
extends AbstractExtendedWizardPage {
    private static final Logger logger = Logger.getLogger(PagePeakSelectionMSD.class);
    private IRetentionIndexWizardElements wizardElements;
    private SelectedPeakChromatogramUI selectedPeakChromatogramUI;
    private SimpleMassSpectrumUI simpleMassSpectrumUI;
    private PeakTableViewerUI peakTableViewerUI;
    private static final int PEAK_SHOW = 1;
    private static final int PEAKS_DELETE = 2;

    public PagePeakSelectionMSD(IRetentionIndexWizardElements wizardElements) {
        super(PagePeakSelectionMSD.class.getName());
        this.setTitle("Peak Selection MSD");
        this.setDescription("Please select the peaks that shall be used.");
        this.wizardElements = wizardElements;
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IChromatogramSelectionMSD chromatogramSelectionMSD = this.getChromatogramSelectionMSD();
            this.wizardElements.setChromatogramSelectionMSD(chromatogramSelectionMSD);
            if (chromatogramSelectionMSD != null) {
                IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
                List peaks = chromatogramMSD.getPeaks();
                this.peakTableViewerUI.setInput(peaks);
                if (peaks.size() > 0) {
                    IChromatogramPeakMSD selectedPeak = (IChromatogramPeakMSD)peaks.get(0);
                    chromatogramSelectionMSD.setSelectedPeak(selectedPeak);
                    this.selectedPeakChromatogramUI.updateSelection((IChromatogramSelection)chromatogramSelectionMSD, true);
                    this.simpleMassSpectrumUI.update((IScanMSD)selectedPeak.getExtractedMassSpectrum(), true);
                }
            }
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createChromatogramField(composite);
        this.createMassSpectrumField(composite);
        this.createPeakTableField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createChromatogramField(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new FillLayout());
        this.selectedPeakChromatogramUI = new SelectedPeakChromatogramUI(parent, 2048);
    }

    private void createMassSpectrumField(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new FillLayout());
        this.simpleMassSpectrumUI = new SimpleMassSpectrumUI(parent, 2048, MassValueDisplayPrecision.NOMINAL);
    }

    private void createPeakTableField(Composite composite) {
        this.peakTableViewerUI = new PeakTableViewerUI(composite, 2050);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        this.peakTableViewerUI.getTable().setLayoutData((Object)gridData);
        this.peakTableViewerUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PagePeakSelectionMSD.this.propagateChange(1);
            }
        });
        this.peakTableViewerUI.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && e.stateMask == 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                    messageBox.setText("Delete peak(s)");
                    messageBox.setMessage("Would you like to delete the selected peak(s)?");
                    if (messageBox.open() == 64) {
                        PagePeakSelectionMSD.this.propagateChange(2);
                    }
                }
            }
        });
    }

    private void propagateChange(int option) {
        Table table = this.peakTableViewerUI.getTable();
        int index = table.getSelectionIndex();
        Object object = this.peakTableViewerUI.getElementAt(index);
        IChromatogramSelectionMSD chromatogramSelectionMSD = this.wizardElements.getChromatogramSelectionMSD();
        if (chromatogramSelectionMSD != null && object instanceof IChromatogramPeakMSD) {
            IChromatogramPeakMSD selectedPeak = (IChromatogramPeakMSD)object;
            switch (option) {
                case 1: {
                    chromatogramSelectionMSD.setSelectedPeak(selectedPeak);
                    this.simpleMassSpectrumUI.update((IScanMSD)selectedPeak.getExtractedMassSpectrum(), true);
                    break;
                }
                case 2: {
                    List<IChromatogramPeakMSD> peaksToDelete = this.getSelectionChromatogramPeakList();
                    IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
                    chromatogramMSD.removePeaks(peaksToDelete);
                    chromatogramSelectionMSD.reset();
                    this.peakTableViewerUI.setInput(chromatogramMSD.getPeaks());
                }
            }
            this.selectedPeakChromatogramUI.updateSelection((IChromatogramSelection)chromatogramSelectionMSD, true);
        }
    }

    private IChromatogramSelectionMSD getChromatogramSelectionMSD() {
        ChromatogramSelectionMSD chromatogramSelectionMSD = null;
        ImportChromatogramRunnable runnable = new ImportChromatogramRunnable(this.wizardElements);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
            IChromatogram chromatogram = runnable.getChromatogram();
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                chromatogramSelectionMSD = new ChromatogramSelectionMSD((IChromatogram)chromatogramMSD);
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        return chromatogramSelectionMSD;
    }

    private List<IChromatogramPeakMSD> getSelectionChromatogramPeakList() {
        int[] indices;
        Table table = this.peakTableViewerUI.getTable();
        ArrayList<IChromatogramPeakMSD> peakList = new ArrayList<IChromatogramPeakMSD>();
        int[] nArray = indices = table.getSelectionIndices();
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IChromatogramPeakMSD) {
                IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)object;
                peakList.add(chromatogramPeak);
            }
            ++n2;
        }
        return peakList;
    }

    private void validateSelection() {
        IChromatogramMSD chromatogramMSD;
        String message = null;
        if (this.wizardElements.getChromatogramWizardElementsMSD().getSelectedChromatograms().size() == 0) {
            message = "No chromatogram has been selected.";
        }
        if (message == null && this.wizardElements.getChromatogramSelectionMSD() == null) {
            message = "The chromatogram couldn't be loaded.";
        }
        if (message == null && ((chromatogramMSD = this.wizardElements.getChromatogramSelectionMSD().getChromatogramMSD()) == null || chromatogramMSD.getPeaks().size() == 0)) {
            message = "There is no peak available.";
        }
        this.updateStatus(message);
    }
}

