/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AbstractAmdisWriter;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class AmdisMSPWriter
extends AbstractAmdisWriter
implements IMassSpectraWriter {
    private static final Logger logger = Logger.getLogger(AmdisMSPWriter.class);

    public void writeMassSpectrum(FileWriter fileWriter, IScanMSD massSpectrum, IProgressMonitor monitor) throws IOException {
        IScanMSD normalizedMassSpectrum;
        try {
            normalizedMassSpectrum = this.makeDeepCopyAndNormalize(massSpectrum);
        }
        catch (CloneNotSupportedException e) {
            logger.warn((Object)e);
            return;
        }
        IIdentificationTarget identificationTarget = this.getIdentificationTarget(normalizedMassSpectrum);
        fileWriter.write(String.valueOf(this.getNameField(massSpectrum, identificationTarget)) + this.CRLF);
        String synonyms = this.getSynonyms(normalizedMassSpectrum);
        if (synonyms != null && !synonyms.equals("")) {
            fileWriter.write(synonyms);
        }
        fileWriter.write(String.valueOf(this.getCommentsField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getRetentionTimeField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getRetentionIndexField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getFormulaField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getMWField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getCasNumberField(identificationTarget)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getSmilesField(identificationTarget)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getNumberOfPeaks(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(this.getMassSpectra(normalizedMassSpectrum));
        fileWriter.write(this.CRLF);
        fileWriter.flush();
    }

    private String getSynonyms(IScanMSD massSpectrum) {
        ILibraryMassSpectrum libraryMassSpectrum;
        Set synonyms;
        StringBuilder builder = new StringBuilder();
        if (massSpectrum instanceof ILibraryMassSpectrum && (synonyms = (libraryMassSpectrum = (ILibraryMassSpectrum)massSpectrum).getLibraryInformation().getSynonyms()).size() > 0) {
            for (String synonym : synonyms) {
                builder.append("Synon: ");
                builder.append(synonym);
                builder.append(this.CRLF);
            }
        }
        return builder.toString();
    }

    private String getMassSpectra(IScanMSD massSpectrum) {
        StringBuilder builder = new StringBuilder();
        List ions = massSpectrum.getIons();
        for (IIon ion : ions) {
            builder.append(AbstractIon.getIon((double)ion.getIon()));
            builder.append(" ");
            builder.append(AbstractIon.getAbundance((float)ion.getAbundance()));
            builder.append(";");
            builder.append(this.CRLF);
        }
        return builder.toString();
    }
}

