/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.IVendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractAmdisWriter
implements IMassSpectraWriter {
    public float NORMALIZATION_BASE = 1000.0f;
    public String CRLF = "\r\n";
    private static final Logger logger = Logger.getLogger(AbstractAmdisWriter.class);
    private static final float FACTOR = 100.0f;
    private NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    private static final int FRACTION_DIGITS = 3;
    private static final int MAX_SPECTRA_CHUNK = 65535;
    private TargetExtendedComparator targetExtendedComparator;

    public AbstractAmdisWriter() {
        this.numberFormat.setMinimumFractionDigits(3);
        this.numberFormat.setMaximumFractionDigits(3);
        this.targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);
    }

    public void write(File file, IScanMSD massSpectrum, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        this.writeMassSpectrum(fileWriter, massSpectrum, monitor);
        fileWriter.close();
    }

    public void write(File file, IMassSpectra massSpectra, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        if (massSpectra.size() > 65535 && PreferenceSupplier.isSplitLibrary()) {
            file.delete();
            List<IMassSpectra> splittedMassSpectra = this.getSplittedMassSpectra(massSpectra);
            int counter = 1;
            for (IMassSpectra massSpectraChunk : splittedMassSpectra) {
                String filePath = file.getAbsolutePath();
                String fileExtension = filePath.substring(filePath.lastIndexOf("."), filePath.length());
                filePath = filePath.replace(fileExtension, "-" + counter + fileExtension);
                FileWriter fileWriter = new FileWriter(new File(filePath), append);
                this.writeMassSpectra(fileWriter, massSpectraChunk, monitor);
                fileWriter.close();
                ++counter;
            }
        } else {
            FileWriter fileWriter = new FileWriter(file, append);
            this.writeMassSpectra(fileWriter, massSpectra, monitor);
            fileWriter.close();
        }
    }

    private List<IMassSpectra> getSplittedMassSpectra(IMassSpectra massSpectra) {
        ArrayList<IMassSpectra> splittedMassSpectra = new ArrayList<IMassSpectra>();
        MassSpectra massSpectraChunk = new MassSpectra();
        int counter = 1;
        int i = 1;
        while (i <= massSpectra.size()) {
            IScanMSD massSpectrum = massSpectra.getMassSpectrum(i);
            if (counter <= 65535) {
                massSpectraChunk.addMassSpectrum(massSpectrum);
                ++counter;
            } else {
                splittedMassSpectra.add((IMassSpectra)massSpectraChunk);
                massSpectraChunk = new MassSpectra();
                massSpectraChunk.addMassSpectrum(massSpectrum);
                counter = 1;
            }
            ++i;
        }
        splittedMassSpectra.add((IMassSpectra)massSpectraChunk);
        return splittedMassSpectra;
    }

    private void writeMassSpectra(FileWriter fileWriter, IMassSpectra massSpectra, IProgressMonitor monitor) throws IOException {
        int i = 1;
        while (i <= massSpectra.size()) {
            IScanMSD massSpectrum = massSpectra.getMassSpectrum(i);
            if (massSpectrum != null && massSpectrum.getNumberOfIons() > 0) {
                this.writeMassSpectrum(fileWriter, massSpectrum, monitor);
            }
            ++i;
        }
    }

    protected IScanMSD makeDeepCopyAndNormalize(IScanMSD massSpectrum) throws CloneNotSupportedException {
        IScanMSD normalizedMassSpectrum = massSpectrum.makeDeepCopy();
        normalizedMassSpectrum.normalize(this.NORMALIZATION_BASE);
        this.removeIonsWithAnTooLowAbundance(normalizedMassSpectrum, 1.0f);
        return normalizedMassSpectrum;
    }

    protected void removeIonsWithAnTooLowAbundance(IScanMSD normalizedMassSpectrum, float minimumAbundance) {
        ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
        for (IIon ion : normalizedMassSpectrum.getIons()) {
            if (!(ion.getAbundance() < minimumAbundance)) continue;
            ionsToRemove.add(ion);
        }
        for (IIon ion : ionsToRemove) {
            normalizedMassSpectrum.removeIon(ion);
        }
    }

    protected String getNameField(IScanMSD massSpectrum, IIdentificationTarget identificationTarget) {
        String field = "NAME: ";
        String identifier = massSpectrum.getIdentifier();
        field = identifier != null && !identifier.equals("") ? String.valueOf(field) + identifier : (identificationTarget != null ? String.valueOf(field) + identificationTarget.getLibraryInformation().getName() : String.valueOf(field) + "NO IDENTIFIER AVAILABLE");
        return field;
    }

    protected IIdentificationTarget getIdentificationTarget(IScanMSD massSpectrum) {
        MassSpectrumTarget identificationTarget = null;
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            try {
                identificationTarget = new MassSpectrumTarget(libraryMassSpectrum.getLibraryInformation(), (IComparisonResult)new ComparisonResult(100.0f, 100.0f, 100.0f, 100.0f));
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
        } else if (massSpectrum instanceof IRegularMassSpectrum) {
            List targets = massSpectrum.getTargets();
            Collections.sort(targets, this.targetExtendedComparator);
            if (targets.size() >= 1) {
                identificationTarget = (IIdentificationTarget)targets.get(0);
            }
        }
        return identificationTarget;
    }

    protected String getCasNumberField(IIdentificationTarget identificationTarget) {
        String field = "CASNO: ";
        if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getLibraryInformation().getCasNumber();
        }
        return field;
    }

    protected String getSmilesField(IIdentificationTarget identificationTarget) {
        String field = "SMILES: ";
        if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getLibraryInformation().getSmiles();
        }
        return field;
    }

    protected String getCommentsField(IScanMSD massSpectrum) {
        String field = "COMMENTS: ";
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + regularMassSpectrum.getLibraryInformation().getComments();
        }
        return field;
    }

    protected String getSourceField(IScanMSD massSpectrum, IIdentificationTarget identificationTarget) {
        String field = "SOURCE: ";
        if (massSpectrum instanceof IVendorLibraryMassSpectrum) {
            IVendorLibraryMassSpectrum amdisMassSpectrum = (IVendorLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + amdisMassSpectrum.getSource();
        } else if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getIdentifier();
        }
        return field;
    }

    protected String getRetentionTimeField(IScanMSD massSpectrum) {
        String field = "RT: ";
        if (massSpectrum instanceof IRegularMassSpectrum) {
            IRegularMassSpectrum regularMassSpectrum = (IRegularMassSpectrum)massSpectrum;
            field = String.valueOf(field) + this.numberFormat.format((double)regularMassSpectrum.getRetentionTime() / 60000.0);
        } else {
            field = String.valueOf(field) + this.numberFormat.format(0.0);
        }
        return field;
    }

    protected String getRetentionIndexField(IScanMSD massSpectrum) {
        String field = "RI: ";
        if (massSpectrum instanceof IRegularMassSpectrum) {
            IRegularMassSpectrum regularMassSpectrum = (IRegularMassSpectrum)massSpectrum;
            field = String.valueOf(field) + this.numberFormat.format(regularMassSpectrum.getRetentionIndex());
        } else {
            field = String.valueOf(field) + this.numberFormat.format(0.0);
        }
        return field;
    }

    protected String getNumberOfPeaks(IScanMSD massSpectrum) {
        String field = "NUM PEAKS: ";
        field = String.valueOf(field) + massSpectrum.getNumberOfIons();
        return field;
    }

    protected String getFormulaField(IScanMSD massSpectrum) {
        String field = "FORMULA: ";
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + regularMassSpectrum.getLibraryInformation().getFormula();
        }
        return field;
    }

    protected String getMWField(IScanMSD massSpectrum) {
        String field = "MW: ";
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + regularMassSpectrum.getLibraryInformation().getMolWeight();
        }
        return field;
    }
}

