/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.converter.msp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.AbstractMassSpectrumExportConverter;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.MassSpectrumExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.internal.converter.SpecificationValidatorMSP;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AmdisMSPWriter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSPMassSpectrumExportConverter
extends AbstractMassSpectrumExportConverter {
    private static final Logger logger = Logger.getLogger(MSPMassSpectrumExportConverter.class);
    private static final String DESCRIPTION = "AMDIS MSP MassSpectrum Export";

    public IMassSpectrumExportConverterProcessingInfo convert(File file, IScanMSD massSpectrum, boolean append, IProgressMonitor monitor) {
        MassSpectrumExportConverterProcessingInfo processingInfo = new MassSpectrumExportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file, massSpectrum);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                file = SpecificationValidatorMSP.validateSpecification(file);
                AmdisMSPWriter massSpectraWriter = new AmdisMSPWriter();
                massSpectraWriter.write(file, massSpectrum, append, monitor);
                processingInfo.setFile(file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IMassSpectrumExportConverterProcessingInfo convert(File file, IMassSpectra massSpectra, boolean append, IProgressMonitor monitor) {
        MassSpectrumExportConverterProcessingInfo processingInfo = new MassSpectrumExportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file, massSpectra);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                file = SpecificationValidatorMSP.validateSpecification(file);
                AmdisMSPWriter massSpectraWriter = new AmdisMSPWriter();
                massSpectraWriter.write(file, massSpectra, append, monitor);
                processingInfo.setFile(file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IScanMSD massSpectrum) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages((IProcessingInfo)super.validate(massSpectrum));
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IMassSpectra massSpectra) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages((IProcessingInfo)super.validate(massSpectra));
        return processingInfo;
    }
}

