/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaStructureDiffViewer
extends StructureDiffViewer
implements IElementChangedListener {
    private static final String SMART = "SMART";
    private ActionContributionItem fSmartActionItem;
    private JavaStructureCreator fStructureCreator = new JavaStructureCreator();
    private boolean fThreeWay;

    public JavaStructureDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setStructureCreator((IStructureCreator)this.fStructureCreator);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    protected void initialSelection() {
        Object[] children;
        DiffNode firstClass = null;
        Object o = this.getRoot();
        if (o != null && (children = this.getSortedChildren(o)) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                o = children[i];
                Object[] sortedChildren = this.getSortedChildren(o);
                if (sortedChildren != null && sortedChildren.length > 0) {
                    int j = 0;
                    while (j < sortedChildren.length) {
                        JavaNode jn;
                        int tc;
                        DiffNode dn;
                        ITypedElement e;
                        o = sortedChildren[j];
                        if (o instanceof DiffNode && (e = (dn = (DiffNode)o).getId()) instanceof JavaNode && ((tc = (jn = (JavaNode)e).getTypeCode()) == 5 || tc == 4)) {
                            firstClass = dn;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (firstClass != null) {
            this.expandToLevel(firstClass, 1);
        } else {
            this.expandToLevel(2);
        }
    }

    protected void compareInputChanged(ICompareInput input) {
        this.fThreeWay = input != null ? input.getAncestor() != null : false;
        this.setSmartButtonVisible(this.fThreeWay);
        if (input != null) {
            Map<String, String> compilerOptions = this.getCompilerOptions(input.getAncestor());
            if (compilerOptions == null) {
                compilerOptions = this.getCompilerOptions(input.getLeft());
            }
            if (compilerOptions == null) {
                compilerOptions = this.getCompilerOptions(input.getRight());
            }
            if (compilerOptions != null) {
                this.fStructureCreator.setDefaultCompilerOptions(compilerOptions);
            }
        }
        super.compareInputChanged(input);
    }

    private Map<String, String> getCompilerOptions(ITypedElement input) {
        IJavaProject javaProject;
        IJavaElement element = this.findJavaElement(input);
        if (element != null && (javaProject = element.getJavaProject()) != null) {
            return javaProject.getOptions(true);
        }
        return null;
    }

    protected void handleDispose(DisposeEvent event) {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        super.handleDispose(event);
    }

    private IJavaElement findJavaElement(ITypedElement element) {
        IResource resource;
        if (element instanceof IResourceProvider && (resource = ((IResourceProvider)element).getResource()) != null) {
            return JavaCore.create((IResource)resource);
        }
        return null;
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        ChangePropertyAction a = new ChangePropertyAction(this.getBundle(), this.getCompareConfiguration(), "action.Smart.", SMART);
        this.fSmartActionItem = new ActionContributionItem((IAction)a);
        this.fSmartActionItem.setVisible(this.fThreeWay);
        toolBarManager.appendToGroup("modes", (IContributionItem)this.fSmartActionItem);
    }

    protected void postDiffHook(Differencer differencer, IDiffContainer root, IProgressMonitor monitor) {
        boolean smart;
        if (this.fStructureCreator.canRewriteTree() && (smart = JavaCompareUtilities.getBoolean(this.getCompareConfiguration(), SMART, false)) && root != null) {
            this.fStructureCreator.rewriteTree(differencer, root);
        }
    }

    protected void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SMART)) {
            this.diff();
        } else {
            super.propertyChange(event);
        }
    }

    private void setSmartButtonVisible(boolean visible) {
        if (this.fSmartActionItem == null) {
            return;
        }
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        this.fSmartActionItem.setVisible(visible);
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)c.getParent());
        if (tbm != null) {
            tbm.update(true);
            ToolBar tb = tbm.getControl();
            if (!tb.isDisposed()) {
                tb.getParent().layout(true);
            }
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        ITypedElement[] elements = this.findAffectedElement(event);
        int i = 0;
        while (i < elements.length) {
            ITypedElement e = elements[i];
            if (e != null && e instanceof IContentChangeNotifier) {
                this.contentChanged((IContentChangeNotifier)e);
            }
            ++i;
        }
    }

    private ITypedElement[] findAffectedElement(ElementChangedEvent event) {
        Object input = this.getInput();
        if (!(input instanceof ICompareInput)) {
            return new ITypedElement[0];
        }
        HashSet<ITypedElement> affectedElements = new HashSet<ITypedElement>();
        ICompareInput ci = (ICompareInput)input;
        IJavaElementDelta delta = event.getDelta();
        this.addAffectedElement(ci.getAncestor(), delta, affectedElements);
        this.addAffectedElement(ci.getLeft(), delta, affectedElements);
        this.addAffectedElement(ci.getRight(), delta, affectedElements);
        return affectedElements.toArray(new ITypedElement[affectedElements.size()]);
    }

    private void addAffectedElement(ITypedElement element, IJavaElementDelta delta, Set<ITypedElement> affectedElements) {
        IJavaElement javaElement = this.findJavaElement(element);
        if (this.isEditable(javaElement) && this.findJavaElementDelta(javaElement, delta) != null) {
            affectedElements.add(element);
        }
    }

    private boolean isEditable(IJavaElement javaElement) {
        return javaElement instanceof ICompilationUnit && JavaModelUtil.isEditable((ICompilationUnit)javaElement);
    }

    private boolean isContentChange(IJavaElementDelta cuDelta) {
        int flags = cuDelta.getFlags();
        return flags != 524288 && (cuDelta.getKind() == 4 || (flags & 1) != 0);
    }

    private boolean canIgnore(IJavaElement cu, IJavaElementDelta[] delta) {
        if (delta.length != 1) {
            return false;
        }
        int flags = delta[0].getFlags();
        if (flags == 65536) {
            return true;
        }
        if (flags == 262144 && delta[0].getElement().equals(cu)) {
            return true;
        }
        return this.canIgnore(cu, delta[0].getAffectedChildren());
    }

    protected IJavaElementDelta findJavaElementDelta(IJavaElement unit, IJavaElementDelta delta) {
        if (delta == null || unit == null) {
            return null;
        }
        IJavaElement element = delta.getElement();
        if (this.canIgnore(unit, delta.getAffectedChildren())) {
            return null;
        }
        if (unit.equals(element)) {
            if (this.isContentChange(delta)) {
                return delta;
            }
            return null;
        }
        if (element.getElementType() > 6) {
            return null;
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            IJavaElementDelta d = this.findJavaElementDelta(unit, children[i]);
            if (d != null) {
                return d;
            }
            ++i;
        }
        return null;
    }

    static class ChangePropertyAction
    extends Action {
        private CompareConfiguration fCompareConfiguration;
        private String fPropertyKey;
        private ResourceBundle fBundle;
        private String fPrefix;

        public ChangePropertyAction(ResourceBundle bundle, CompareConfiguration cc, String rkey, String pkey) {
            this.fPropertyKey = pkey;
            this.fBundle = bundle;
            this.fPrefix = rkey;
            JavaCompareUtilities.initAction((IAction)this, this.fBundle, this.fPrefix);
            this.setCompareConfiguration(cc);
        }

        public void run() {
            boolean b = !JavaCompareUtilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false);
            this.setChecked(b);
            if (this.fCompareConfiguration != null) {
                this.fCompareConfiguration.setProperty(this.fPropertyKey, (Object)new Boolean(b));
            }
        }

        public void setChecked(boolean state) {
            super.setChecked(state);
            JavaCompareUtilities.initToggleAction((IAction)this, this.fBundle, this.fPrefix, state);
        }

        public void setCompareConfiguration(CompareConfiguration cc) {
            this.fCompareConfiguration = cc;
            this.setChecked(JavaCompareUtilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false));
        }
    }
}

