/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.help.internal.search.HTMLDocParser;

public class FilterHTMLHeadAndBodyOutputStream
extends FilterOutputStream {
    private static final int STATE_START = 0;
    private static final int STATE_LT = 1;
    private static final int STATE_LT_SLASH = 2;
    private static final int STATE_LT_SLASH_H = 3;
    private static final int STATE_LT_SLASH_HE = 4;
    private static final int STATE_LT_SLASH_HEA = 5;
    private static final int STATE_LT_SLASH_HEAD = 6;
    private static final int STATE_AFTER_HEAD = 7;
    private static final int STATE_LT_B = 8;
    private static final int STATE_LT_BO = 9;
    private static final int STATE_LT_BOD = 10;
    private static final int STATE_LT_BODY = 11;
    private static final int STATE_DONE = 17;
    private static final int STATE_LT_M = 18;
    private static final int STATE_LT_ME = 19;
    private static final int STATE_LT_MET = 20;
    private static final int STATE_LT_META = 21;
    private int areaState = 0;
    private int state = 0;
    private byte[] toHead;
    private String bodyContent;
    private String charset;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream(7);

    public FilterHTMLHeadAndBodyOutputStream(OutputStream out, byte[] bytesForHead, String bodyContent) {
        super(out);
        this.toHead = bytesForHead;
        this.bodyContent = bodyContent;
    }

    @Override
    public final void write(int b) throws IOException {
        switch (this.state) {
            case 0: 
            case 7: {
                if (b == 60) {
                    this.buffer.write(b);
                    this.state = 1;
                    break;
                }
                this.out.write(b);
                break;
            }
            case 1: {
                this.buffer.write(b);
                if (b == 47) {
                    this.state = 2;
                    break;
                }
                if (b == 98 || b == 66) {
                    this.state = 8;
                    break;
                }
                if (b == 109 || b == 77) {
                    this.state = 18;
                    break;
                }
                this.reset();
                break;
            }
            case 18: {
                this.buffer.write(b);
                if (b == 101 || b == 69) {
                    this.state = 19;
                    break;
                }
                this.reset();
                break;
            }
            case 19: {
                this.buffer.write(b);
                if (b == 116 || b == 84) {
                    this.state = 20;
                    break;
                }
                this.reset();
                break;
            }
            case 20: {
                this.buffer.write(b);
                if (b == 97 || b == 65) {
                    this.state = 21;
                    break;
                }
                this.reset();
                break;
            }
            case 21: {
                this.buffer.write(b);
                if (b != 62) break;
                this.parseMetaTag(this.buffer);
                this.reset();
                break;
            }
            case 8: {
                this.buffer.write(b);
                if (b == 111 || b == 79) {
                    this.state = 9;
                    break;
                }
                this.reset();
                break;
            }
            case 9: {
                this.buffer.write(b);
                if (b == 100 || b == 68) {
                    this.state = 10;
                    break;
                }
                this.reset();
                break;
            }
            case 10: {
                this.buffer.write(b);
                if (b == 121 || b == 89) {
                    this.state = 11;
                    break;
                }
                this.reset();
                break;
            }
            case 11: {
                this.buffer.write(b);
                if (b != 62) break;
                this.out.write(this.buffer.toByteArray());
                this.buffer.reset();
                if (this.bodyContent != null) {
                    String encoding = this.charset != null ? this.charset : "ASCII";
                    byte[] bodyBytes = this.bodyContent.getBytes(encoding);
                    String bodyRecoded = new String(bodyBytes, encoding);
                    if (bodyRecoded.equals(this.bodyContent)) {
                        this.out.write(10);
                        this.out.write(bodyBytes);
                        this.out.write(10);
                    } else {
                        this.out.write(10);
                        int i = 0;
                        while (i < this.bodyContent.length()) {
                            String nextChar = this.bodyContent.substring(i, i + 1);
                            byte[] codedChar = nextChar.getBytes(encoding);
                            String decodedChar = new String(codedChar, encoding);
                            if (decodedChar.equals(nextChar)) {
                                this.out.write(codedChar);
                            } else {
                                char value = this.bodyContent.charAt(i);
                                String code = "&#" + value + ';';
                                this.out.write(code.getBytes());
                            }
                            ++i;
                        }
                        this.out.write(10);
                    }
                }
                this.areaState = 17;
                this.state = 17;
                break;
            }
            case 2: {
                this.buffer.write(b);
                if (b == 104 || b == 72) {
                    this.state = 3;
                    break;
                }
                this.reset();
                break;
            }
            case 3: {
                this.buffer.write(b);
                if (b == 101 || b == 69) {
                    this.state = 4;
                    break;
                }
                this.reset();
                break;
            }
            case 4: {
                this.buffer.write(b);
                if (b == 97 || b == 65) {
                    this.state = 5;
                    break;
                }
                this.reset();
                break;
            }
            case 5: {
                this.buffer.write(b);
                if (b == 100 || b == 68) {
                    this.state = 6;
                    break;
                }
                this.reset();
                break;
            }
            case 6: {
                this.buffer.write(b);
                if (b == 62) {
                    if (this.toHead != null) {
                        this.out.write(this.toHead);
                        this.out.write(10);
                    }
                    this.areaState = 7;
                    this.state = 7;
                    this.out.write(this.buffer.toByteArray());
                    this.buffer.reset();
                    break;
                }
                this.reset();
                break;
            }
            default: {
                this.out.write(b);
            }
        }
    }

    private void parseMetaTag(ByteArrayOutputStream buffer) {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());
        String value = HTMLDocParser.getCharsetFromHTML((InputStream)is);
        try {
            is.close();
        }
        catch (IOException iOException) {}
        if (value != null) {
            this.charset = value;
        }
    }

    private void reset() throws IOException {
        this.out.write(this.buffer.toByteArray());
        this.buffer.reset();
        this.state = this.areaState;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.state == 17) {
            this.out.write(b, off, len);
        } else {
            int i = 0;
            while (i < len) {
                this.write(b[off + i]);
                ++i;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.reset();
        super.close();
    }
}

