/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import java.util.Calendar;
import java.util.Iterator;
import org.eclipse.nebula.visualization.xygraph.dataprovider.AbstractDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBuffer;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.widgets.Display;

public class CircularBufferDataProvider
extends AbstractDataProvider {
    private CircularBuffer<ISample> traceData;
    private double currentXData;
    private double currentYData;
    private long currentYDataTimestamp;
    private boolean currentXDataChanged = false;
    private boolean currentYDataChanged = false;
    private double[] currentXDataArray = new double[0];
    private double[] currentYDataArray = new double[0];
    private boolean currentXDataArrayChanged = false;
    private boolean currentYDataArrayChanged = false;
    private boolean xAxisDateEnabled = false;
    private int updateDelay = 0;
    private boolean duringDelay = false;
    private boolean concatenate_data = true;
    protected boolean dataRangedirty = false;
    private UpdateMode updateMode = UpdateMode.X_AND_Y;
    private PlotMode plotMode = PlotMode.LAST_N;
    private Runnable fireUpdate;
    private int clippingWindow = -1;

    public CircularBufferDataProvider(boolean chronological) {
        super(chronological);
        this.traceData = new CircularBuffer(100);
        this.fireUpdate = new Runnable(){

            @Override
            public void run() {
                for (IDataProviderListener listener : CircularBufferDataProvider.this.listeners) {
                    listener.dataChanged(CircularBufferDataProvider.this);
                }
                CircularBufferDataProvider.this.duringDelay = false;
            }
        };
    }

    public synchronized void setCurrentXData(double newValue) {
        this.currentXData = newValue;
        this.currentXDataChanged = true;
        this.tryToAddDataPoint();
    }

    public synchronized void setCurrentYData(double newValue) {
        this.currentYData = newValue;
        this.currentYDataChanged = true;
        this.xAxisDateEnabled = false;
        this.tryToAddDataPoint();
    }

    public synchronized void addSample(ISample sample) {
        if (this.traceData.size() == this.traceData.getBufferSize() && this.plotMode == PlotMode.N_STOP) {
            return;
        }
        this.traceData.add(sample);
        this.fireDataChange();
    }

    public synchronized void setCurrentYDataTimestamp(long timestamp) {
        if (!this.xAxisDateEnabled) {
            this.clearTrace();
            this.xAxisDateEnabled = true;
        }
        this.currentYDataTimestamp = timestamp;
        if (this.currentYDataChanged) {
            this.tryToAddDataPoint();
        }
    }

    public synchronized void setCurrentYData(double newValue, long timestamp) {
        this.xAxisDateEnabled = true;
        this.currentYData = newValue;
        this.currentYDataChanged = true;
        this.currentYDataTimestamp = timestamp;
        this.tryToAddDataPoint();
    }

    private void tryToAddDataPoint() {
        if (this.traceData.size() == this.traceData.getBufferSize() && this.plotMode == PlotMode.N_STOP) {
            return;
        }
        switch (this.updateMode) {
            case X_OR_Y: {
                if ((!this.chronological || !this.currentYDataChanged) && (this.chronological || !this.currentXDataChanged && !this.currentYDataChanged)) break;
                this.addDataPoint();
                break;
            }
            case X_AND_Y: {
                if ((!this.chronological || !this.currentYDataChanged) && (this.chronological || !this.currentXDataChanged || !this.currentYDataChanged)) break;
                this.addDataPoint();
                break;
            }
            case X: {
                if ((!this.chronological || !this.currentYDataChanged) && (this.chronological || !this.currentXDataChanged)) break;
                this.addDataPoint();
                break;
            }
            case Y: {
                if (!this.currentYDataChanged) break;
                this.addDataPoint();
                break;
            }
        }
    }

    private void addDataPoint() {
        if (!this.concatenate_data) {
            this.traceData.clear();
        }
        double newXValue = this.chronological ? (this.xAxisDateEnabled ? (this.updateMode != UpdateMode.TRIGGER ? (double)this.currentYDataTimestamp : (double)Calendar.getInstance().getTimeInMillis()) : (this.traceData.size() == 0 ? 0.0 : this.traceData.getTail().getXValue() + 1.0)) : this.currentXData;
        this.traceData.add(new Sample(newXValue, this.currentYData));
        this.currentXDataChanged = false;
        this.currentYDataChanged = false;
        this.fireDataChange();
    }

    public synchronized void setCurrentXDataArray(double[] newValue) {
        this.currentXDataArray = newValue;
        this.currentXDataArrayChanged = true;
        this.tryToAddDataArray();
    }

    public synchronized void setCurrentYDataArray(double[] newValue) {
        this.currentYDataArray = newValue;
        this.currentYDataArrayChanged = true;
        this.tryToAddDataArray();
    }

    private void tryToAddDataArray() {
        if (this.traceData.size() == this.traceData.getBufferSize() && this.plotMode == PlotMode.N_STOP) {
            return;
        }
        switch (this.updateMode) {
            case X_OR_Y: {
                if ((!this.chronological || !this.currentYDataArrayChanged) && (this.chronological || !this.currentXDataArrayChanged && !this.currentYDataArrayChanged)) break;
                this.addDataArray();
                break;
            }
            case X_AND_Y: {
                if ((!this.chronological || !this.currentYDataArrayChanged) && (this.chronological || !this.currentXDataArrayChanged || !this.currentYDataArrayChanged)) break;
                this.addDataArray();
                break;
            }
            case X: {
                if ((!this.chronological || !this.currentYDataArrayChanged) && (this.chronological || !this.currentXDataArrayChanged)) break;
                this.addDataArray();
                break;
            }
            case Y: {
                if (!this.currentYDataArrayChanged) break;
                this.addDataArray();
                break;
            }
        }
    }

    private void addDataArray() {
        if (!this.concatenate_data) {
            this.traceData.clear();
        }
        if (this.chronological) {
            int i;
            double[] newXValueArray = new double[this.currentYDataArray.length];
            if (this.traceData.size() == 0) {
                i = 0;
                while (i < this.currentYDataArray.length) {
                    newXValueArray[i] = i;
                    ++i;
                }
            } else {
                i = 1;
                while (i < this.currentYDataArray.length + 1) {
                    newXValueArray[i - 1] = this.traceData.getTail().getXValue() + (double)i;
                    ++i;
                }
            }
            i = 0;
            while (i < Math.min(this.traceData.getBufferSize(), Math.min(newXValueArray.length, this.currentYDataArray.length))) {
                this.traceData.add(new Sample(newXValueArray[i], this.currentYDataArray[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < Math.min(this.traceData.getBufferSize(), Math.min(this.currentXDataArray.length, this.currentYDataArray.length))) {
                this.traceData.add(new Sample(this.currentXDataArray[i], this.currentYDataArray[i]));
                ++i;
            }
        }
        this.currentXDataArrayChanged = false;
        this.currentYDataArrayChanged = false;
        this.fireDataChange();
    }

    public synchronized void clearTrace() {
        this.traceData.clear();
        this.currentXDataArray = new double[0];
        this.currentYDataArray = new double[0];
        this.currentXDataChanged = false;
        this.currentYDataChanged = false;
        this.currentXDataArrayChanged = false;
        this.currentYDataArrayChanged = false;
        this.fireDataChange();
    }

    public Iterator<ISample> iterator() {
        return this.traceData.iterator();
    }

    public synchronized void setBufferSize(int bufferSize) {
        this.traceData.setBufferSize(bufferSize, false);
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public void triggerUpdate() {
        if (this.traceData.size() == 0 && !this.currentYDataChanged && !this.currentYDataArrayChanged) {
            return;
        }
        if (this.currentYDataArray.length > 0) {
            this.addDataArray();
        } else {
            this.addDataPoint();
        }
    }

    @Override
    protected void innerUpdate() {
        this.dataRangedirty = true;
    }

    @Override
    protected void updateDataRange() {
        if (!this.dataRangedirty) {
            return;
        }
        this.dataRangedirty = false;
        if (this.getSize() > 0) {
            double yMin;
            double xMin;
            int lowerBound = 0;
            if (this.getSize() > this.clippingWindow && this.clippingWindow > 0) {
                lowerBound = this.getSize() - 1 - this.clippingWindow;
            }
            double xMax = xMin = this.getSample(lowerBound).getXValue();
            double yMax = yMin = this.getSample(lowerBound).getYValue();
            int i = lowerBound + 1;
            while (i < this.getSize()) {
                ISample dp = this.getSample(i);
                if (xMin > dp.getXValue() - dp.getXMinusError()) {
                    xMin = dp.getXValue() - dp.getXMinusError();
                }
                if (xMax < dp.getXValue() + dp.getXPlusError()) {
                    xMax = dp.getXValue() + dp.getXPlusError();
                }
                if (yMin > dp.getYValue() - dp.getYMinusError()) {
                    yMin = dp.getYValue() - dp.getYMinusError();
                }
                if (yMax < dp.getYValue() + dp.getYPlusError()) {
                    yMax = dp.getYValue() + dp.getYPlusError();
                }
                ++i;
            }
            this.xDataMinMax = new Range(xMin, xMax);
            this.yDataMinMax = new Range(yMin, yMax);
        } else {
            this.xDataMinMax = null;
            this.yDataMinMax = null;
        }
    }

    public void setPlotMode(PlotMode plotMode) {
        this.plotMode = plotMode;
    }

    @Override
    public ISample getSample(int index) {
        return this.traceData.getElement(index);
    }

    @Override
    public int getSize() {
        return this.traceData.size();
    }

    public void setXAxisDateEnabled(boolean xAxisDateEnabled) {
        this.xAxisDateEnabled = xAxisDateEnabled;
    }

    public synchronized void setUpdateDelay(int updateDelay) {
        this.updateDelay = updateDelay;
    }

    @Override
    protected synchronized void fireDataChange() {
        if (this.updateDelay > 0) {
            this.innerUpdate();
            if (!this.duringDelay) {
                Display.getCurrent().timerExec(this.updateDelay, this.fireUpdate);
                this.duringDelay = true;
            }
        } else {
            super.fireDataChange();
        }
    }

    public void setConcatenate_data(boolean concatenate_data) {
        this.concatenate_data = concatenate_data;
    }

    public boolean isConcatenate_data() {
        return this.concatenate_data;
    }

    public void setClippingWindow(int clippingWindow) {
        assert (clippingWindow >= 0);
        assert (clippingWindow <= this.getSize());
        this.clippingWindow = clippingWindow;
    }

    public int getClippingWindow() {
        return this.clippingWindow;
    }

    public static enum PlotMode {
        LAST_N("Plot last n pts."),
        N_STOP("Plot n pts & stop.");

        private String description;

        private PlotMode(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[PlotMode.values().length];
            int i = 0;
            PlotMode[] plotModeArray = PlotMode.values();
            int n = plotModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlotMode p = plotModeArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }

    public static enum UpdateMode {
        X_OR_Y("X or Y"),
        X_AND_Y("X AND Y"),
        X("X"),
        Y("Y"),
        TRIGGER("Trigger");

        private String description;

        private UpdateMode(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[UpdateMode.values().length];
            int i = 0;
            UpdateMode[] updateModeArray = UpdateMode.values();
            int n = updateModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateMode p = updateModeArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }
}

