/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.swt.ui.components.peak;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.swt.ui.internal.provider.PeakListContentProvider;
import org.eclipse.chemclipse.csd.swt.ui.internal.provider.PeakListLabelProvider;
import org.eclipse.chemclipse.csd.swt.ui.internal.provider.PeakListTableComparator;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PeakListUI {
    private ExtendedTableViewer tableViewer;
    private PeakListTableComparator peakListTableComparator;
    private String[] titles = new String[]{"RT (minutes)", "RI", "Area", "Start RT", "Stop RT", "Width", "Scan# at Peak Maximum", "S/N", "Leading", "Tailing", "Model Description", "Suggested Components"};
    private int[] bounds = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};

    public PeakListUI(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(parent, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new PeakListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PeakListLabelProvider());
        this.peakListTableComparator = new PeakListTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.peakListTableComparator);
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    PeakListUI.this.tableViewer.copyToClipboard(PeakListUI.this.titles);
                }
            }
        });
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(IPeaks peaks, boolean forceReload) {
        if (peaks != null) {
            this.tableViewer.setInput((Object)peaks);
        }
    }

    public void clear() {
        this.tableViewer.setInput(null);
    }

    public ExtendedTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public void deleteSelectedPeaks(IChromatogramSelectionCSD chromatogramSelection) {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        List<IChromatogramPeakCSD> peaksToDelete = this.getChromatogramPeakList(table, indices);
        table.remove(indices);
        IChromatogramCSD chromatogram = chromatogramSelection.getChromatogramCSD();
        chromatogram.removePeaks(peaksToDelete);
        if (chromatogramSelection instanceof ChromatogramSelectionCSD) {
            ChromatogramSelectionCSD chromSelection = (ChromatogramSelectionCSD)chromatogramSelection;
            List peaks = chromatogram.getPeaks();
            if (peaks.size() > 0) {
                chromSelection.setSelectedPeak((IChromatogramPeakCSD)peaks.get(0));
            }
            chromSelection.update(true);
        }
    }

    private List<IChromatogramPeakCSD> getChromatogramPeakList(Table table, int[] indices) {
        ArrayList<IChromatogramPeakCSD> peakList = new ArrayList<IChromatogramPeakCSD>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IChromatogramPeakCSD) {
                IChromatogramPeakCSD chromatogramPeak = (IChromatogramPeakCSD)object;
                peakList.add(chromatogramPeak);
            }
            ++n2;
        }
        return peakList;
    }
}

