/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public abstract class AbstractOverrider
implements IConfigLabelAccumulator {
    private Map<Serializable, List<String>> overrides = new HashMap<Serializable, List<String>>();

    public void removeOverride(Serializable key) {
        this.overrides.remove(key);
    }

    public void registerOverrides(Serializable key, String ... configLabels) {
        this.registerOverrides(key, ArrayUtil.asList(configLabels));
    }

    public void registerOverrides(Serializable key, List<String> configLabels) {
        List<String> existingOverrides = this.getOverrides(key);
        if (existingOverrides == null) {
            this.overrides.put(key, configLabels);
        } else {
            for (String configLabel : configLabels) {
                if (existingOverrides.contains(configLabel)) continue;
                existingOverrides.add(configLabel);
            }
        }
    }

    public void registerOverridesOnTop(Serializable key, String ... configLabels) {
        this.registerOverridesOnTop(key, ArrayUtil.asList(configLabels));
    }

    public void registerOverridesOnTop(Serializable key, List<String> configLabels) {
        List<String> existingOverrides = this.getOverrides(key);
        if (existingOverrides == null) {
            this.overrides.put(key, configLabels);
        } else {
            int i = configLabels.size() - 1;
            while (i >= 0) {
                String configLabel = configLabels.get(i);
                if (!existingOverrides.contains(configLabel)) {
                    existingOverrides.add(0, configLabel);
                }
                --i;
            }
        }
    }

    public Map<Serializable, List<String>> getOverrides() {
        return this.overrides;
    }

    public List<String> getOverrides(Serializable key) {
        return this.overrides.get(key);
    }

    public void addOverrides(Map<Serializable, List<String>> overrides) {
        this.overrides.putAll(overrides);
    }
}

