/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnRename;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.PersistenceUtils;

public class RenameColumnHelper
implements IPersistable {
    public static final String PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS = ".renamedColumnHeaders";
    private final ColumnHeaderLayer columnHeaderLayer;
    protected Map<Integer, String> renamedColumnsLabelsByIndex = new TreeMap<Integer, String>();

    public RenameColumnHelper(ColumnHeaderLayer columnHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
    }

    public boolean renameColumnPosition(int columnPosition, String customColumnName) {
        int index = this.columnHeaderLayer.getColumnIndexByPosition(columnPosition);
        return this.renameColumnIndex(index, customColumnName);
    }

    public boolean renameColumnIndex(int index, String customColumnName) {
        if (index >= 0) {
            if (customColumnName == null) {
                this.renamedColumnsLabelsByIndex.remove(index);
            } else {
                this.renamedColumnsLabelsByIndex.put(index, customColumnName);
            }
            return true;
        }
        return false;
    }

    public String getRenamedColumnLabel(int columnIndex) {
        return this.renamedColumnsLabelsByIndex.get(columnIndex);
    }

    public boolean isColumnRenamed(int columnIndex) {
        return this.renamedColumnsLabelsByIndex.get(columnIndex) != null;
    }

    public boolean isAnyColumnRenamed() {
        return this.renamedColumnsLabelsByIndex.size() > 0;
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        Object property = properties.get(String.valueOf(prefix) + PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS);
        try {
            this.renamedColumnsLabelsByIndex = PersistenceUtils.parseString(property);
        }
        catch (Exception e) {
            System.err.println("Error while restoring renamed column headers: " + e.getMessage());
            System.err.println("Skipping restore.");
            this.renamedColumnsLabelsByIndex.clear();
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        String string = PersistenceUtils.mapAsString(this.renamedColumnsLabelsByIndex);
        if (string != null && string.length() > 0) {
            properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS, string);
        }
    }
}

