/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PerspectiveSwitcherLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final Logger logger = Logger.getLogger(PerspectiveSwitcherLabelProvider.class);
    private Map<URL, Image> imageMap = new HashMap<URL, Image>();

    public Image getColumnImage(Object element, int columnIndex) {
        Image iconImage = null;
        if (columnIndex == 0 && element instanceof MPerspective) {
            MPerspective perspective = (MPerspective)element;
            try {
                URL iconURL = new URL(perspective.getIconURI());
                iconImage = this.imageMap.get(iconURL);
                if (iconImage == null) {
                    iconImage = ImageDescriptor.createFromURL((URL)iconURL).createImage();
                    this.imageMap.put(iconURL, iconImage);
                }
            }
            catch (MalformedURLException e) {
                logger.warn((Object)e);
            }
        }
        return iconImage;
    }

    public void dispose() {
        super.dispose();
        for (URL iconURL : this.imageMap.keySet()) {
            Image iconImage = this.imageMap.get(iconURL);
            if (iconImage == null) continue;
            iconImage.dispose();
        }
        this.imageMap.clear();
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof MPerspective) {
            MPerspective perspective = (MPerspective)element;
            switch (columnIndex) {
                case 0: {
                    text = perspective.getLabel();
                    if (text != null && !text.equals("")) break;
                    text = "Nameless perspective";
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }
}

