/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.Activator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.IonRemoverMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.IonRemoverPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.SupplierFilterSettings;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.support.util.IonListUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_IONS_TO_REMOVE = "ionsToRemove";
    public static final String P_USE_SETTINGS = "useSettings";
    public static final String DEF_IONS_TO_REMOVE = "18;28;84;207";
    public static final boolean DEF_USE_SETTINGS = true;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
        defaultValues.put(P_USE_SETTINGS, Boolean.toString(true));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static IChromatogramFilterSettings getChromatogramFilterSettings() {
        SupplierFilterSettings chromatogramFilterSettings = new SupplierFilterSettings();
        IMarkedIons ionsToRemove = chromatogramFilterSettings.getIonsToRemove();
        PreferenceSupplier.setMarkedIons(ionsToRemove, PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        return chromatogramFilterSettings;
    }

    public static IPeakFilterSettings getPeakFilterSettings() {
        IonRemoverPeakFilterSettings peakFilterSettings = new IonRemoverPeakFilterSettings();
        IMarkedIons ionsToRemove = peakFilterSettings.getIonsToRemove();
        PreferenceSupplier.setMarkedIons(ionsToRemove, PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        return peakFilterSettings;
    }

    public static IMassSpectrumFilterSettings getMassSpectrumFilterSettings() {
        IonRemoverMassSpectrumFilterSettings massSpectrumFilterSettings = new IonRemoverMassSpectrumFilterSettings();
        IMarkedIons ionsToRemove = massSpectrumFilterSettings.getIonsToRemove();
        PreferenceSupplier.setMarkedIons(ionsToRemove, PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        return massSpectrumFilterSettings;
    }

    public static void setMarkedIons(IMarkedIons markedIons, Set<Integer> ions) {
        for (int ion : ions) {
            markedIons.add((Object)new MarkedIon((double)ion));
        }
    }

    public static Set<Integer> getIons(String preference, String def) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        IonListUtil ionListUtil = new IonListUtil();
        String preferenceEntry = preferences.get(preference, def);
        return ionListUtil.getIons(preferenceEntry);
    }

    public static boolean useSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_USE_SETTINGS, true);
    }

    public static Set<Integer> getIons() {
        return PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
    }
}

