/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.identification.SynonymsEditUI;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractMassSpectrumSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SynonymsView
extends AbstractMassSpectrumSelectionView {
    @Inject
    private Composite parent;
    private SynonymsEditUI synonymsEditUI;

    @Inject
    public SynonymsView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.synonymsEditUI = new SynonymsEditUI(this.parent, 0);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.synonymsEditUI.update(this.getLibraryInformation(this.getMassSpectrum()), true);
    }

    @Override
    public void update(IScanMSD massSpectrum, boolean forceReload) {
        if (this.doUpdate(massSpectrum)) {
            this.synonymsEditUI.update(this.getLibraryInformation(massSpectrum), true);
        }
    }

    private ILibraryInformation getLibraryInformation(IScanMSD massSpectrum) {
        ILibraryInformation libraryInformation = null;
        if (massSpectrum instanceof ILibraryMassSpectrum) {
            ILibraryMassSpectrum libraryMassSpectrum = (ILibraryMassSpectrum)massSpectrum;
            libraryInformation = libraryMassSpectrum.getLibraryInformation();
        }
        return libraryInformation;
    }
}

