/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.PeakTargetsContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractTargetsView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PeakTargetsView
extends AbstractTargetsView {
    @Inject
    private Composite parent;
    @Inject
    private EPartService partService;
    @Inject
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandlerChromatogramSelection;
    private EventHandler eventHandlerPeak;
    private IPeakMSD peak;
    private Map<String, Object> map;

    @Inject
    public PeakTargetsView(IEventBroker eventBroker) {
        super((IStructuredContentProvider)new PeakTargetsContentProvider(), eventBroker);
        this.eventBroker = eventBroker;
        this.map = new HashMap<String, Object>();
    }

    @PostConstruct
    private void createControl() {
        super.createPartControl(this.parent);
        this.subscribe();
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode != 127 && e.stateMask == 0) {
                    PeakTargetsView.this.propagateSelectedTargetAndMassSpectrum();
                }
            }
        });
        tableViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PeakTargetsView.this.propagateSelectedTargetAndMassSpectrum();
            }
        });
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        super.setFocus();
        this.updatePeakTargets(this.peak, false);
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandlerChromatogramSelection = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    if (chromatogramSelection != null) {
                        PeakTargetsView.this.peak = (IPeakMSD)chromatogramSelection.getSelectedPeak();
                        PeakTargetsView.this.updatePeakTargets(PeakTargetsView.this.peak, forceReload);
                    }
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandlerChromatogramSelection);
            this.eventHandlerPeak = new EventHandler(){

                public void handleEvent(Event event) {
                    PeakTargetsView.this.peak = (IPeakMSD)event.getProperty("PeakMSD");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    PeakTargetsView.this.updatePeakTargets(PeakTargetsView.this.peak, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/peak", this.eventHandlerPeak);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null) {
            if (this.eventHandlerChromatogramSelection != null) {
                this.eventBroker.unsubscribe(this.eventHandlerChromatogramSelection);
            }
            if (this.eventHandlerPeak != null) {
                this.eventBroker.unsubscribe(this.eventHandlerPeak);
            }
        }
    }

    private boolean doUpdate(IPeakMSD peak) {
        return this.isPartVisible() && peak != null;
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void updatePeakTargets(IPeakMSD peak, boolean forceReload) {
        if (this.doUpdate(peak)) {
            super.update((Object)peak, forceReload);
            this.getTableViewer().getTable().setSelection(0);
            this.propagateSelectedTargetAndMassSpectrum();
        }
    }

    private void propagateSelectedTargetAndMassSpectrum() {
        TableItem tableItem;
        Object object;
        Table table = this.getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index >= 0 && (object = (tableItem = table.getItem(index)).getData()) instanceof IIdentificationTarget) {
            IIdentificationTarget identificationTarget = (IIdentificationTarget)object;
            this.map.clear();
            this.map.put("MassSpectrumUnknown", this.peak.getExtractedMassSpectrum());
            this.map.put("IdentificationTarget", identificationTarget);
            this.eventBroker.send("identification/target/update/massspectrum/unknown", this.map);
        }
    }
}

