/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.comparator.ChromatogramPeakComparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.peak.PeakListUI;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PeakListMSDView
extends AbstractChromatogramSelectionMSDView {
    private static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.msd.ui.perspective.views.peakListMSDView.popup";
    @Inject
    private Composite parent;
    private PeakListUI peakListUI;
    private IChromatogramPeakMSD firstPeak = null;
    private double firstIntegratedArea = 0.0;
    private IChromatogramPeakMSD lastPeak = null;
    private double lastIntegratedArea = 0.0;
    private float retentionIndexSum = 0.0f;
    private IChromatogramSelectionMSD chromatogramSelectionMSDFocused;
    private ChromatogramPeakComparator chromatogramPeakComparator = new ChromatogramPeakComparator(SortOrder.ASC);
    private boolean peakDeleteUpdate = false;

    @Inject
    public PeakListMSDView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.peakListUI = new PeakListUI(this.parent, 0);
        ExtendedTableViewer tableViewer = this.peakListUI.getTableViewer();
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object element;
                ISelection selection;
                if (event != null && (selection = event.getSelection()) instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IChromatogramPeakMSD) {
                    IChromatogramSelectionMSD chromatogramSelection = PeakListMSDView.this.getChromatogramSelection();
                    if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
                        Display display = Display.getDefault();
                        try {
                            if (display != null) {
                                display.getCursorControl().setCursor(display.getSystemCursor(1));
                            }
                            IChromatogramPeakMSD selectedPeak = (IChromatogramPeakMSD)element;
                            ((ChromatogramSelectionMSD)chromatogramSelection).setSelectedPeak(selectedPeak, false);
                            if (PreferenceSupplier.isMoveRetentionTimeOnPeakSelection()) {
                                PeakListMSDView.this.adjustChromatogramSelection(selectedPeak, chromatogramSelection);
                            }
                            ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionMSD)chromatogramSelection, (boolean)true);
                        }
                        finally {
                            if (display != null) {
                                display.getCursorControl().setCursor(display.getSystemCursor(0));
                            }
                        }
                    }
                    chromatogramSelection = null;
                }
            }
        });
        tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    PeakListMSDView.this.peakListUI.getTableViewer().copyToClipboard(PeakListMSDView.this.peakListUI.getTitles());
                } else if (e.keyCode == 127 && e.stateMask == 0) {
                    PeakListMSDView.this.deleteSelectedPeaks();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.peakListUI.getTableViewer().getControl().setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection)) {
            IChromatogramPeakMSD selectedPeak = chromatogramSelection.getSelectedPeak();
            this.peakListUI.setLabelSelectedPeak(selectedPeak);
            this.peakListUI.setChromatogramSelection((IChromatogramSelection)chromatogramSelection);
            if (this.chromatogramSelectionMSDFocused == null || this.chromatogramSelectionMSDFocused != chromatogramSelection) {
                this.chromatogramSelectionMSDFocused = chromatogramSelection;
                List peakList = chromatogramSelection.getChromatogramMSD().getPeaks(chromatogramSelection);
                IPeaks peaks = this.getPeaks(peakList);
                this.peakListUI.update(peaks, forceReload);
            } else {
                this.updatePeaksInList(chromatogramSelection, forceReload);
            }
        } else if (chromatogramSelection == null) {
            this.chromatogramSelectionMSDFocused = null;
            if (this.isPartVisible()) {
                this.peakListUI.clear();
            }
        }
    }

    private void deleteSelectedPeaks() {
        Shell shell = Display.getCurrent().getActiveShell();
        MessageBox messageBox = new MessageBox(shell, 456);
        messageBox.setText("Delete Selected Peaks");
        messageBox.setMessage("Do you really want to delete the selected peaks?");
        int decision = messageBox.open();
        if (64 == decision) {
            this.peakDeleteUpdate = true;
            this.peakListUI.deleteSelectedPeaks(this.getChromatogramSelection());
        }
    }

    private void deactivateSelectedPeaks() {
        this.peakListUI.setActiveStatusSelectedPeaks(this.getChromatogramSelection(), false);
    }

    private void activateSelectedPeaks() {
        this.peakListUI.setActiveStatusSelectedPeaks(this.getChromatogramSelection(), true);
    }

    private void exportSelectedPeaks() {
        this.peakListUI.exportSelectedPeaks(this.getChromatogramSelection());
    }

    private void updatePeaksInList(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        List peakList = chromatogramSelection.getChromatogramMSD().getPeaks(chromatogramSelection);
        int size = peakList.size();
        if (size > 0) {
            if (size == 1) {
                this.checkFirstPeakUpdate(peakList, forceReload);
            } else {
                this.checkFirstAndLastPeakUpdate(peakList, forceReload);
            }
        } else {
            this.peakListUI.clear();
            this.firstPeak = null;
            this.firstIntegratedArea = 0.0;
            this.lastPeak = null;
            this.lastIntegratedArea = 0.0;
            this.retentionIndexSum = 0.0f;
        }
    }

    private void checkFirstPeakUpdate(List<IChromatogramPeakMSD> peakList, boolean forceReload) {
        IChromatogramPeakMSD peak = peakList.get(0);
        if (this.firstPeak != peak || this.peakDeleteUpdate) {
            this.peakDeleteUpdate = false;
            this.firstPeak = peak;
            this.firstIntegratedArea = peak.getIntegratedArea();
            this.retentionIndexSum = this.getSumRetentionIndices(peakList);
            IPeaks peaks = this.getPeaks(peakList);
            this.peakListUI.update(peaks, forceReload);
        } else if (this.reloadList(false)) {
            this.peakListUI.getTableViewer().refresh();
        } else if (forceReload && this.checkReloadRetetionIndices(peakList, forceReload)) {
            this.retentionIndexSum = this.getSumRetentionIndices(peakList);
            this.peakListUI.getTableViewer().refresh();
        }
    }

    private void checkFirstAndLastPeakUpdate(List<IChromatogramPeakMSD> peakList, boolean forceReload) {
        int size = peakList.size();
        IChromatogramPeakMSD peakOne = peakList.get(0);
        IChromatogramPeakMSD peakTwo = peakList.get(size - 1);
        if (this.firstPeak != peakOne || this.lastPeak != peakTwo || this.peakDeleteUpdate) {
            this.peakDeleteUpdate = false;
            this.firstPeak = peakOne;
            this.firstIntegratedArea = peakOne.getIntegratedArea();
            this.lastPeak = peakTwo;
            this.lastIntegratedArea = peakTwo.getIntegratedArea();
            this.retentionIndexSum = this.getSumRetentionIndices(peakList);
            IPeaks peaks = this.getPeaks(peakList);
            this.peakListUI.update(peaks, forceReload);
        } else if (this.reloadList(true)) {
            this.peakListUI.getTableViewer().refresh();
        } else if (forceReload && this.checkReloadRetetionIndices(peakList, forceReload)) {
            this.retentionIndexSum = this.getSumRetentionIndices(peakList);
            this.peakListUI.getTableViewer().refresh();
        }
    }

    private boolean checkReloadRetetionIndices(List<IChromatogramPeakMSD> peakList, boolean forceReload) {
        return this.retentionIndexSum != this.getSumRetentionIndices(peakList);
    }

    private float getSumRetentionIndices(List<IChromatogramPeakMSD> peakList) {
        float sumRetentionIndices = 0.0f;
        for (IChromatogramPeakMSD peak : peakList) {
            sumRetentionIndices += peak.getPeakModel().getPeakMaximum().getRetentionIndex();
        }
        return sumRetentionIndices;
    }

    private IPeaks getPeaks(List<IChromatogramPeakMSD> peakList) {
        Peaks peaks = new Peaks();
        for (IChromatogramPeakMSD peak : peakList) {
            peaks.addPeak((IPeak)peak);
        }
        return peaks;
    }

    private boolean reloadList(boolean checkSecondPeak) {
        if (this.firstPeak != null && this.firstPeak.getIntegratedArea() != this.firstIntegratedArea) {
            return true;
        }
        return checkSecondPeak && this.lastPeak != null && this.lastPeak.getIntegratedArea() != this.lastIntegratedArea;
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListMSDView.this.peakListUI.getTableViewer().copyToClipboard(PeakListMSDView.this.peakListUI.getTitles());
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListMSDView.this.deleteSelectedPeaks();
                    }
                };
                action.setText("Delete the selected peak(s)");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListMSDView.this.deactivateSelectedPeaks();
                    }
                };
                action.setText("Deactivate the selected peak(s)");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListMSDView.this.activateSelectedPeaks();
                    }
                };
                action.setText("Activate the selected peak(s)");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListMSDView.this.exportSelectedPeaks();
                    }
                };
                action.setText("Export the selected peak(s)");
                manager.add((IAction)action);
            }
        });
        ExtendedTableViewer tableViewer = this.peakListUI.getTableViewer();
        Menu menu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }

    private void adjustChromatogramSelection(IChromatogramPeakMSD selectedPeak, IChromatogramSelectionMSD chromatogramSelection) {
        IChromatogramMSD chromatogramMSD = chromatogramSelection.getChromatogramMSD();
        List peaks = chromatogramMSD.getPeaks();
        List peaksSelection = chromatogramMSD.getPeaks(chromatogramSelection);
        Collections.sort(peaks, this.chromatogramPeakComparator);
        Collections.sort(peaksSelection, this.chromatogramPeakComparator);
        if (!((IChromatogramPeakMSD)peaks.get(0)).equals(selectedPeak) && !((IChromatogramPeakMSD)peaks.get(peaks.size() - 1)).equals(selectedPeak)) {
            if (((IChromatogramPeakMSD)peaksSelection.get(0)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
            } else if (((IChromatogramPeakMSD)peaksSelection.get(peaksSelection.size() - 1)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
            }
        }
    }
}

