/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.core;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.AbstractBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.processing.IBaselineDetectorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.SnipCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.ISnipBaselineDetectorSettings;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineDetector
extends AbstractBaselineDetector {
    public IBaselineDetectorProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        IBaselineDetectorProcessingInfo processingInfo = super.validate(chromatogramSelection, baselineDetectorSettings, monitor);
        if (!processingInfo.hasErrorMessages()) {
            this.calculateBaseline(chromatogramSelection, baselineDetectorSettings, monitor);
        }
        return processingInfo;
    }

    public IBaselineDetectorProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        IBaselineDetectorSettings baselineDetectorSettings = PreferenceSupplier.getBaselineDetectorSettings();
        return this.setBaseline(chromatogramSelection, baselineDetectorSettings, monitor);
    }

    private void calculateBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        ScanRange scanRange = new ScanRange(startScan, stopScan);
        int iterations = 0;
        int windowSize = 0;
        if (baselineDetectorSettings instanceof ISnipBaselineDetectorSettings) {
            ISnipBaselineDetectorSettings snipSettings = (ISnipBaselineDetectorSettings)baselineDetectorSettings;
            iterations = snipSettings.getIterations();
            windowSize = snipSettings.getWindowSize().getSize();
        } else {
            iterations = PreferenceSupplier.getIterations();
            windowSize = PreferenceSupplier.getWindowSize().getSize();
        }
        if (scanRange.getWidth() <= windowSize) {
            return;
        }
        try {
            TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals totalIonSignals = totalScanSignalExtractor.getTotalScanSignals(startScan, stopScan);
            this.calculateSNIPBaseline(totalIonSignals, iterations, monitor);
            IBaselineModel baselineModel = chromatogram.getBaselineModel();
            this.applyBaseline(baselineModel, totalIonSignals, startScan, stopScan, monitor);
        }
        catch (ChromatogramIsNullException chromatogramIsNullException) {
            return;
        }
    }

    private void calculateSNIPBaseline(ITotalScanSignals totalIonSignals, int iterations, IProgressMonitor monitor) {
        int size = totalIonSignals.size();
        float[] intensityValues = new float[size];
        int counter = 0;
        for (ITotalScanSignal signal : totalIonSignals.getTotalScanSignals()) {
            intensityValues[counter++] = signal.getTotalSignal();
        }
        SnipCalculator snipCalculator = new SnipCalculator();
        snipCalculator.calculateBaselineIntensityValues(intensityValues, iterations, monitor);
        counter = 0;
        for (ITotalScanSignal signal : totalIonSignals.getTotalScanSignals()) {
            signal.setTotalSignal(intensityValues[counter++]);
        }
    }

    private void applyBaseline(IBaselineModel baselineModel, ITotalScanSignals totalIonSignals, int startScan, int stopScan, IProgressMonitor monitor) {
        int scan = startScan;
        while (scan < stopScan) {
            monitor.subTask("Apply baseline to scan: " + scan);
            ITotalScanSignal actualTotalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            ITotalScanSignal nextTotalIonSignal = totalIonSignals.getNextTotalScanSignal(scan);
            int startRetentionTime = actualTotalIonSignal.getRetentionTime();
            float startBackgroundAbundance = actualTotalIonSignal.getTotalSignal();
            int stopRetentionTime = nextTotalIonSignal.getRetentionTime();
            float stopBackgroundAbundance = nextTotalIonSignal.getTotalSignal();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++scan;
        }
    }
}

