/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.TricubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.TrivariateGridInterpolator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.MathArrays;

@Deprecated
public class TricubicSplineInterpolator
implements TrivariateGridInterpolator {
    @Override
    public TricubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[] zval, double[][][] fval) throws NoDataException, NumberIsTooSmallException, DimensionMismatchException, NonMonotonicSequenceException {
        int i;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        MathArrays.checkOrder(zval);
        int xLen = xval.length;
        int yLen = yval.length;
        int zLen = zval.length;
        double[][][] fvalXY = new double[zLen][xLen][yLen];
        double[][][] fvalZX = new double[yLen][zLen][xLen];
        int i2 = 0;
        while (i2 < xLen) {
            if (fval[i2].length != yLen) {
                throw new DimensionMismatchException(fval[i2].length, yLen);
            }
            int j = 0;
            while (j < yLen) {
                if (fval[i2][j].length != zLen) {
                    throw new DimensionMismatchException(fval[i2][j].length, zLen);
                }
                int k = 0;
                while (k < zLen) {
                    double v;
                    fvalXY[k][i2][j] = v = fval[i2][j][k];
                    fvalZX[j][k][i2] = v;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        BicubicSplineInterpolator bsi = new BicubicSplineInterpolator(true);
        BicubicSplineInterpolatingFunction[] xSplineYZ = new BicubicSplineInterpolatingFunction[xLen];
        int i3 = 0;
        while (i3 < xLen) {
            xSplineYZ[i3] = bsi.interpolate(yval, zval, fval[i3]);
            ++i3;
        }
        BicubicSplineInterpolatingFunction[] ySplineZX = new BicubicSplineInterpolatingFunction[yLen];
        int j = 0;
        while (j < yLen) {
            ySplineZX[j] = bsi.interpolate(zval, xval, fvalZX[j]);
            ++j;
        }
        BicubicSplineInterpolatingFunction[] zSplineXY = new BicubicSplineInterpolatingFunction[zLen];
        int k = 0;
        while (k < zLen) {
            zSplineXY[k] = bsi.interpolate(xval, yval, fvalXY[k]);
            ++k;
        }
        double[][][] dFdX = new double[xLen][yLen][zLen];
        double[][][] dFdY = new double[xLen][yLen][zLen];
        double[][][] d2FdXdY = new double[xLen][yLen][zLen];
        int k2 = 0;
        while (k2 < zLen) {
            BicubicSplineInterpolatingFunction f = zSplineXY[k2];
            i = 0;
            while (i < xLen) {
                double x = xval[i];
                int j2 = 0;
                while (j2 < yLen) {
                    double y = yval[j2];
                    dFdX[i][j2][k2] = f.partialDerivativeX(x, y);
                    dFdY[i][j2][k2] = f.partialDerivativeY(x, y);
                    d2FdXdY[i][j2][k2] = f.partialDerivativeXY(x, y);
                    ++j2;
                }
                ++i;
            }
            ++k2;
        }
        double[][][] dFdZ = new double[xLen][yLen][zLen];
        double[][][] d2FdYdZ = new double[xLen][yLen][zLen];
        i = 0;
        while (i < xLen) {
            BicubicSplineInterpolatingFunction f = xSplineYZ[i];
            int j3 = 0;
            while (j3 < yLen) {
                double y = yval[j3];
                int k3 = 0;
                while (k3 < zLen) {
                    double z = zval[k3];
                    dFdZ[i][j3][k3] = f.partialDerivativeY(y, z);
                    d2FdYdZ[i][j3][k3] = f.partialDerivativeXY(y, z);
                    ++k3;
                }
                ++j3;
            }
            ++i;
        }
        double[][][] d2FdZdX = new double[xLen][yLen][zLen];
        int j4 = 0;
        while (j4 < yLen) {
            BicubicSplineInterpolatingFunction f = ySplineZX[j4];
            int k4 = 0;
            while (k4 < zLen) {
                double z = zval[k4];
                int i4 = 0;
                while (i4 < xLen) {
                    double x = xval[i4];
                    d2FdZdX[i4][j4][k4] = f.partialDerivativeXY(z, x);
                    ++i4;
                }
                ++k4;
            }
            ++j4;
        }
        double[][][] d3FdXdYdZ = new double[xLen][yLen][zLen];
        int i5 = 0;
        while (i5 < xLen) {
            int nI = this.nextIndex(i5, xLen);
            int pI = this.previousIndex(i5);
            int j5 = 0;
            while (j5 < yLen) {
                int nJ = this.nextIndex(j5, yLen);
                int pJ = this.previousIndex(j5);
                int k5 = 0;
                while (k5 < zLen) {
                    int nK = this.nextIndex(k5, zLen);
                    int pK = this.previousIndex(k5);
                    d3FdXdYdZ[i5][j5][k5] = (fval[nI][nJ][nK] - fval[nI][pJ][nK] - fval[pI][nJ][nK] + fval[pI][pJ][nK] - fval[nI][nJ][pK] + fval[nI][pJ][pK] + fval[pI][nJ][pK] - fval[pI][pJ][pK]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]) * (zval[nK] - zval[pK]));
                    ++k5;
                }
                ++j5;
            }
            ++i5;
        }
        return new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, dFdX, dFdY, dFdZ, d2FdXdY, d2FdZdX, d2FdYdZ, d3FdXdYdZ);
    }

    private int nextIndex(int i, int max) {
        int index = i + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i) {
        int index = i - 1;
        return index >= 0 ? index : 0;
    }
}

