/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoPeakFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.PeakFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.FilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.PeakSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.support.MassSpectrumFileSupport;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PeakMassSpectrumEditUIWithLabel
extends Composite
implements IChromatogramSelectionMSDUpdateNotifier {
    private static final Logger logger = Logger.getLogger(PeakMassSpectrumEditUIWithLabel.class);
    private SimpleMassSpectrumUI massSpectrumUI;
    private Button addSubtractMassSpectrumButton;
    private Button saveButton;
    private Combo filterCombo;
    private Combo identifierCombo;
    private Label infoLabel;
    private IChromatogramSelectionMSD chromatogramSelection;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private MassValueDisplayPrecision massValueDisplayPrecision;
    private List<String> peakFilterIds;
    private String[] peakFilterNames;
    private List<String> peakIdentifierIds;
    private String[] peakIdentifierNames;
    private IEventBroker eventBroker;

    public PeakMassSpectrumEditUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision, IEventBroker eventBroker) {
        super(parent, style);
        this.eventBroker = eventBroker;
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        try {
            IPeakFilterSupport peakFilterSupport = PeakFilter.getPeakFilterSupport();
            this.peakFilterIds = peakFilterSupport.getAvailableFilterIds();
            this.peakFilterNames = peakFilterSupport.getFilterNames();
        }
        catch (NoPeakFilterSupplierAvailableException noPeakFilterSupplierAvailableException) {
            this.peakFilterIds = new ArrayList<String>();
            this.peakFilterNames = new String[0];
        }
        try {
            IPeakIdentifierSupport peakIdentifierSupport = PeakIdentifier.getPeakIdentifierSupport();
            this.peakIdentifierIds = peakIdentifierSupport.getAvailableIdentifierIds();
            this.peakIdentifierNames = peakIdentifierSupport.getIdentifierNames();
        }
        catch (NoIdentifierAvailableException noIdentifierAvailableException) {
            this.peakIdentifierIds = new ArrayList<String>();
            this.peakIdentifierNames = new String[0];
        }
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite labelbar = new Composite(composite, 4);
        labelbar.setLayout((Layout)new GridLayout(7, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        labelbar.setLayoutData((Object)gridData);
        this.addSubtractMassSpectrumButton = new Button(labelbar, 8);
        this.addSubtractMassSpectrumButton.setText("");
        this.addSubtractMassSpectrumButton.setImage(ApplicationImageFactory.getInstance().getImage("subtractFilterAddSelectedScan.gif", "16x16"));
        this.addSubtractMassSpectrumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection != null) {
                    String perspectiveId = "org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.chromatogramPeaks";
                    String viewId = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.part.sessionSubtractMassSpectrum";
                    PerspectiveSwitchHandler.focusPerspectiveAndView((String)perspectiveId, (String)viewId);
                    PreferenceSupplier.setSessionSubtractMassSpectrum(null);
                    IScanMSD sessionSubtractMassSpectrum = PreferenceSupplier.getSessionSubtractMassSpectrum();
                    boolean useNormalize = PreferenceSupplier.isUseNormalize();
                    IScanMSD normalizedMassSpectrum = FilterSupport.getCombinedMassSpectrum((IScanMSD)sessionSubtractMassSpectrum, (IScanMSD)PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedScan(), null, (boolean)useNormalize);
                    PreferenceSupplier.setSessionSubtractMassSpectrum((IScanMSD)normalizedMassSpectrum);
                    PeakMassSpectrumEditUIWithLabel.this.eventBroker.send("filter/supplier/subtract/update/session/subtractmassspectrum", (Object)true);
                }
            }
        });
        this.filterCombo = new Combo(labelbar, 0);
        this.filterCombo.setLayoutData((Object)new GridData(768));
        this.filterCombo.setItems(this.peakFilterNames);
        Button filterButton = new Button(labelbar, 0);
        filterButton.setText("Filter");
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PeakMassSpectrumEditUIWithLabel.this.filterCombo.getSelectionIndex();
                if (index >= 0 && index < PeakMassSpectrumEditUIWithLabel.this.peakFilterIds.size()) {
                    String filterId = (String)PeakMassSpectrumEditUIWithLabel.this.peakFilterIds.get(index);
                    if (PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection != null && PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedPeak() != null) {
                        IChromatogramPeakMSD peakMSD = PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedPeak();
                        peakMSD.removeAllTargets();
                        PeakFilter.applyFilter((IPeakMSD)peakMSD, (String)filterId, (IProgressMonitor)new NullProgressMonitor());
                        ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionMSD)PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection, (boolean)true);
                    }
                }
            }
        });
        this.identifierCombo = new Combo(labelbar, 0);
        this.identifierCombo.setItems(this.peakIdentifierNames);
        this.identifierCombo.setLayoutData((Object)new GridData(768));
        Button identifierButton = new Button(labelbar, 0);
        identifierButton.setText("Identify");
        identifierButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PeakMassSpectrumEditUIWithLabel.this.identifierCombo.getSelectionIndex();
                if (index >= 0 && index < PeakMassSpectrumEditUIWithLabel.this.peakIdentifierIds.size()) {
                    String identifierId = (String)PeakMassSpectrumEditUIWithLabel.this.peakIdentifierIds.get(index);
                    if (PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection != null && PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedPeak() != null) {
                        IChromatogramPeakMSD peakMSD = PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedPeak();
                        PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.chromatogramPeaks", (String)"org.eclipse.chemclipse.ux.extension.msd.ui.part.peakTargetsView");
                        IRunnableWithProgress runnable = new IRunnableWithProgress((IPeakMSD)peakMSD, identifierId){
                            private final /* synthetic */ IPeakMSD val$peakMSD;
                            private final /* synthetic */ String val$identifierId;
                            {
                                this.val$peakMSD = iPeakMSD;
                                this.val$identifierId = string;
                            }

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    monitor.beginTask("Peak Identification", -1);
                                    PeakIdentifier.identify((IPeakMSD)this.val$peakMSD, (String)this.val$identifierId, (IProgressMonitor)monitor);
                                    PeakSelectionUpdateNotifier.fireUpdateChange((IPeakMSD)this.val$peakMSD, (boolean)true);
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                        try {
                            monitor.run(true, true, runnable);
                        }
                        catch (InvocationTargetException e1) {
                            logger.warn((Object)e1);
                        }
                        catch (InterruptedException e1) {
                            logger.warn((Object)e1);
                        }
                    }
                }
            }
        });
        this.saveButton = new Button(labelbar, 8);
        this.saveButton.setImage(ApplicationImageFactory.getInstance().getImage("saveas.gif", "16x16"));
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection != null && PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedPeak() != null) {
                        MassSpectrumFileSupport.saveMassSpectrum((IScanMSD)PeakMassSpectrumEditUIWithLabel.this.chromatogramSelection.getSelectedPeak().getExtractedMassSpectrum());
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        this.infoLabel = new Label(labelbar, 0);
        this.infoLabel.setText("");
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 6;
        this.infoLabel.setLayoutData((Object)gridData);
        this.massSpectrumUI = new SimpleMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.massSpectrumUI.setLayoutData(gridData);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        this.chromatogramSelection = chromatogramSelection;
        IChromatogramPeakMSD peakMSD = chromatogramSelection.getSelectedPeak();
        if (peakMSD != null) {
            this.setPeakLabel((IPeakMSD)peakMSD);
            this.massSpectrumUI.update((IScanMSD)peakMSD.getExtractedMassSpectrum(), forceReload);
        }
    }

    private void setPeakLabel(IPeakMSD peakMSD) {
        StringBuilder builder = new StringBuilder();
        if (peakMSD != null) {
            IPeakMassSpectrum massSpectrum = peakMSD.getExtractedMassSpectrum();
            if (massSpectrum instanceof IPeakMassSpectrum) {
                IPeakMassSpectrum actualMassSpectrum = massSpectrum;
                builder.append("Peak: ");
                builder.append(actualMassSpectrum.getScanNumber());
                builder.append(" | ");
                builder.append("RT: ");
                builder.append(this.decimalFormat.format((double)actualMassSpectrum.getRetentionTime() / 60000.0));
                builder.append(" | ");
                builder.append("RI: ");
                if (org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                    builder.append(Integer.toString((int)actualMassSpectrum.getRetentionIndex()));
                } else {
                    builder.append(this.decimalFormat.format(actualMassSpectrum.getRetentionIndex()));
                }
                builder.append(" | ");
                builder.append("Detector: MS");
                builder.append(actualMassSpectrum.getMassSpectrometer());
                builder.append(" | ");
                builder.append("Type: ");
                builder.append(actualMassSpectrum.getMassSpectrumTypeDescription());
                builder.append(" | ");
            }
            builder.append("Signal: ");
            builder.append((int)massSpectrum.getTotalSignal());
        }
        this.infoLabel.setText(builder.toString());
    }
}

