/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.modifier;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.filter.processing.IPeakFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.PeakFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ISubtractFilterSettingsPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class FilterModifierPeak
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "Subtract Filter Peak";
    private IChromatogramSelectionMSD chromatogramSelectionMSD;
    private boolean useSelectedPeak = true;

    public FilterModifierPeak(IChromatogramSelectionMSD chromatogramSelectionMSD, boolean useSelectedPeak) {
        this.chromatogramSelectionMSD = chromatogramSelectionMSD;
        this.useSelectedPeak = useSelectedPeak;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            ISubtractFilterSettingsPeak peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
            IPeakFilterProcessingInfo processingInfo = this.useSelectedPeak ? PeakFilter.applyFilter((IPeakMSD)this.chromatogramSelectionMSD.getSelectedPeak(), (IPeakFilterSettings)peakFilterSettings, (String)"org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.peak", (IProgressMonitor)monitor) : PeakFilter.applyFilter((IChromatogramSelectionMSD)this.chromatogramSelectionMSD, (IPeakFilterSettings)peakFilterSettings, (String)"org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.peak", (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
            this.updateSelection();
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FilterModifierPeak.this.chromatogramSelectionMSD.update(true);
            }
        });
    }
}

