/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.views;

import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.views.IQuantitationCompoundSelectionView;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractQuantitationCompoundSelectionView
extends AbstractSelectionView
implements IQuantitationCompoundSelectionView {
    private IQuantitationCompoundMSD quantitationCompoundMSD;
    private IQuantDatabase database;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractQuantitationCompoundSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IQuantitationCompoundMSD getQuantitationCompoundDocument() {
        return this.quantitationCompoundMSD;
    }

    @Override
    public void setQuantitationCompoundDocument(IQuantitationCompoundMSD quantitationCompoundMSD) {
        this.quantitationCompoundMSD = quantitationCompoundMSD;
    }

    @Override
    public IQuantDatabase getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(IQuantDatabase database) {
        this.database = database;
    }

    @Override
    public boolean doUpdate() {
        return this.isPartVisible();
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    Object objectDocument = event.getProperty("QuantitationCompoundDocument");
                    Object objectDatabase = event.getProperty("Database");
                    if (objectDocument instanceof IQuantitationCompoundMSD && objectDatabase instanceof IQuantDatabase) {
                        AbstractQuantitationCompoundSelectionView.this.quantitationCompoundMSD = (IQuantitationCompoundMSD)objectDocument;
                        AbstractQuantitationCompoundSelectionView.this.database = (IQuantDatabase)objectDatabase;
                        AbstractQuantitationCompoundSelectionView.this.update(AbstractQuantitationCompoundSelectionView.this.quantitationCompoundMSD, AbstractQuantitationCompoundSelectionView.this.database);
                    } else {
                        AbstractQuantitationCompoundSelectionView.this.update(null, null);
                    }
                }
            };
            this.eventBroker.subscribe("quantitation/msd/update/supplier/chemclipse/quantitationcompounddocument", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

