/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabases;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.controller.QuantitationCompoundEntryEdit;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.NoQuantitationTableAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.QuantitationCompoundAlreadyExistsException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationCompoundContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationCompoundLabelProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationCompoundTableComparator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs.QuantitationCompoundEditDialog;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.AbstractTableViewerUI;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class QuantitationCompoundsUI
extends AbstractTableViewerUI {
    private static final Logger logger = Logger.getLogger(QuantitationCompoundsUI.class);
    private static final String MESSAGE_BOX_TEXT = "Quantitation Compounds";
    private Label label;
    private IEventBroker eventBroker;
    private IQuantDatabase database;
    private Map<String, Object> map;

    public QuantitationCompoundsUI(Composite parent, int style, IEventBroker eventBroker) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.addHeader(composite);
        this.addList(composite);
        this.addButtons(composite);
        this.eventBroker = eventBroker;
        this.map = new HashMap<String, Object>();
        this.subscribeToDatabaseUpdates();
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.setTableViewerInput();
    }

    private void addHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridDataHeader = new GridData(768);
        gridDataHeader.horizontalSpan = 2;
        gridDataHeader.grabExcessHorizontalSpace = true;
        gridDataHeader.heightHint = 30;
        composite.setLayoutData((Object)gridDataHeader);
        GridData gridData = new GridData(768);
        gridDataHeader.grabExcessHorizontalSpace = true;
        this.label = new Label(composite, 0);
        this.label.setLayoutData((Object)gridData);
        this.label.setText("Please select a quantitation table.");
    }

    private void addList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridDataTable = new GridData(1808);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)gridDataTable);
        String[] titles = new String[]{"Name", "Chemical Class", "Concentration Unit", "Calibration Method", "Cross Zero", "Use TIC", "Retention Time (RT)", "RT (-)", "RT (+)", "Retention Index (RI)", "RI (-)", "RI (+)"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
        QuantitationCompoundContentProvider contentProvider = new QuantitationCompoundContentProvider();
        QuantitationCompoundLabelProvider labelProvider = new QuantitationCompoundLabelProvider();
        QuantitationCompoundTableComparator viewerTableComparator = new QuantitationCompoundTableComparator();
        this.createTableViewer(composite, gridDataTable, contentProvider, (LabelProvider)labelProvider, viewerTableComparator, titles, bounds);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QuantitationCompoundsUI.this.triggerCompoundDocumentUpdateEvent();
            }
        });
        this.setTableViewerInput();
    }

    private void setTableViewerInput() {
        if (this.database != null) {
            List documents = this.database.getQuantitationCompounds();
            if (documents.size() > 0) {
                this.getTableViewer().setInput((Object)documents);
                this.triggerCompoundDocumentUpdateEvent();
            } else {
                this.getTableViewer().setInput(null);
            }
        }
    }

    private void addButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridDataButtons = new GridData(1040);
        gridDataButtons.verticalAlignment = 128;
        composite.setLayoutData((Object)gridDataButtons);
        GridData gridData = new GridData(768);
        this.addButtonAdd(composite, gridData);
        this.addButtonEdit(composite, gridData);
        this.addButtonRemove(composite, gridData);
        this.addButtonRemoveAll(composite, gridData);
    }

    private void addButtonAdd(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuantitationCompoundsUI.this.database != null) {
                    QuantitationCompoundEntryEdit quantitationCompoundEntryEdit;
                    Shell shell = Display.getCurrent().getActiveShell();
                    QuantitationCompoundEditDialog dialog = new QuantitationCompoundEditDialog(shell, quantitationCompoundEntryEdit = new QuantitationCompoundEntryEdit(), "Create a new quantitation compound.", QuantitationCompoundsUI.this.database, true);
                    if (dialog.open() == 0) {
                        try {
                            IQuantitationCompoundMSD quantitationCompoundMSD = quantitationCompoundEntryEdit.getQuantitationCompoundMSD();
                            QuantitationCompoundsUI.this.database.addQuantitationCompound(quantitationCompoundMSD);
                            QuantitationCompoundsUI.this.setTableViewerInput();
                        }
                        catch (QuantitationCompoundAlreadyExistsException e1) {
                            logger.warn((Object)e1);
                            QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "The quantitation compound already exists in the database.");
                        }
                    }
                } else {
                    QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "No valid database has been selected.");
                }
            }
        });
    }

    private void addButtonEdit(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Edit");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IQuantitationCompoundMSD quantitationCompoundMSD = QuantitationCompoundsUI.this.getSelectedQuantitationCompoundMSD();
                if (quantitationCompoundMSD != null) {
                    if (QuantitationCompoundsUI.this.database != null) {
                        Shell shell = Display.getCurrent().getActiveShell();
                        QuantitationCompoundEntryEdit quantitationCompoundEntryEdit = new QuantitationCompoundEntryEdit();
                        IQuantitationCompoundMSD quantitationCompoundOld = quantitationCompoundMSD;
                        quantitationCompoundEntryEdit.setQuantitationCompoundMSD(quantitationCompoundOld);
                        QuantitationCompoundEditDialog dialog = new QuantitationCompoundEditDialog(shell, quantitationCompoundEntryEdit, "Edit the quantitation compound.", QuantitationCompoundsUI.this.database, false);
                        if (dialog.open() == 0) {
                            IQuantitationCompoundMSD quantitationCompoundNew = quantitationCompoundEntryEdit.getQuantitationCompoundMSD();
                            quantitationCompoundNew.updateQuantitationSignalsMSD(quantitationCompoundOld.getQuantitationSignalsMSD());
                            quantitationCompoundNew.updateConcentrationResponseEntries(quantitationCompoundOld.getConcentrationResponseEntriesMSD());
                            quantitationCompoundMSD.updateQuantitationCompound(quantitationCompoundNew);
                            QuantitationCompoundsUI.this.setTableViewerInput();
                        }
                    } else {
                        QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "No valid database has been selected.");
                    }
                } else {
                    QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "Please select a quantitation compound to edit.");
                }
            }
        });
    }

    private void addButtonRemove(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Delete");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List quantitationCompoundsMSD = QuantitationCompoundsUI.this.getSelectedQuantitationCompoundsMSD();
                if (quantitationCompoundsMSD.size() > 0) {
                    if (QuantitationCompoundsUI.this.database != null) {
                        QuantitationCompoundsUI.this.database.deleteQuantitationCompound(quantitationCompoundsMSD);
                        QuantitationCompoundsUI.this.setTableViewerInput();
                    } else {
                        QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "No valid database has been selected.");
                    }
                } else {
                    QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "Please select a quantitation document.");
                }
            }
        });
    }

    private void addButtonRemoveAll(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Delete All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuantitationCompoundsUI.this.showQuestion(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "Would you like to delete all quantitation compounds?") == 64) {
                    if (QuantitationCompoundsUI.this.database != null) {
                        QuantitationCompoundsUI.this.database.deleteAllQuantitationCompounds();
                        QuantitationCompoundsUI.this.setTableViewerInput();
                    } else {
                        QuantitationCompoundsUI.this.showMessage(QuantitationCompoundsUI.MESSAGE_BOX_TEXT, "No valid database has been selected.");
                    }
                }
            }
        });
    }

    private IQuantitationCompoundMSD getSelectedQuantitationCompoundMSD() {
        IQuantitationCompoundMSD quantitationCompoundDocument = null;
        Object element = this.getSelectedTableItem();
        if (element instanceof IQuantitationCompoundMSD) {
            quantitationCompoundDocument = (IQuantitationCompoundMSD)element;
        }
        return quantitationCompoundDocument;
    }

    private List<IQuantitationCompoundMSD> getSelectedQuantitationCompoundsMSD() {
        ArrayList<IQuantitationCompoundMSD> quantitationCompoundDocuments = new ArrayList<IQuantitationCompoundMSD>();
        List<Object> elements = this.getSelectedTableItems();
        for (Object element : elements) {
            if (!(element instanceof IQuantitationCompoundMSD)) continue;
            IQuantitationCompoundMSD quantitationCompoundDocument = (IQuantitationCompoundMSD)element;
            quantitationCompoundDocuments.add(quantitationCompoundDocument);
        }
        return quantitationCompoundDocuments;
    }

    private void triggerCompoundDocumentUpdateEvent() {
        Object element = this.getSelectedTableItem();
        if (this.eventBroker != null && this.database != null) {
            this.map.clear();
            this.map.put("QuantitationCompoundDocument", element);
            this.map.put("Database", this.database);
            this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationcompounddocument", this.map);
        }
    }

    private void subscribeToDatabaseUpdates() {
        if (this.eventBroker != null) {
            EventHandler eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    Object databaseName = event.getProperty("org.eclipse.e4.data");
                    if (databaseName instanceof String) {
                        QuantitationCompoundsUI.this.setDatabaseInput((String)databaseName);
                    } else {
                        QuantitationCompoundsUI.this.clearDatabaseInput();
                    }
                }
            };
            this.eventBroker.subscribe("quantitation/msd/update/supplier/chemclipse/quantitationtable", eventHandler);
        }
    }

    private void setDatabaseInput(String databaseName) {
        try {
            this.label.setText("Quantitation Table: " + databaseName);
            this.database = QuantDatabases.getQuantDatabase((String)databaseName);
            this.setTableViewerInput();
        }
        catch (NoQuantitationTableAvailableException e) {
            this.clearDatabaseInput();
            logger.warn((Object)e);
        }
    }

    private void clearDatabaseInput() {
        this.database = null;
        this.label.setText("The quantitation table is not available.");
        this.getTableViewer().setInput(null);
        if (this.eventBroker != null) {
            this.map.clear();
            this.map.put("QuantitationCompoundDocument", null);
            this.map.put("Database", null);
            this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationcompounddocument", this.map);
        }
    }
}

