/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.QuantitationCompoundAlreadyExistsException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.SelectDocumentPage;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddPeakToQuantitationTableWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(AddPeakToQuantitationTableWizard.class);
    private SelectDocumentPage documentPage;
    private IQuantDatabase database;
    private IChromatogramPeakMSD chromatogramPeakMSD;
    private DecimalFormat decimalFormat;

    public AddPeakToQuantitationTableWizard(IQuantDatabase database, IChromatogramPeakMSD chromatogramPeakMSD) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add Peak to Quantitation Table");
        this.database = database;
        this.chromatogramPeakMSD = chromatogramPeakMSD;
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    public void addPages() {
        List<String> peakTargetNames = this.getPeakTargetNames(this.chromatogramPeakMSD);
        this.documentPage = new SelectDocumentPage("CreateDoc", peakTargetNames, this.database);
        this.addPage((IWizardPage)this.documentPage);
    }

    public boolean performFinish() {
        this.removeErrorMessage();
        if (this.database == null) {
            this.showErrorMessage("Please select a valid database.");
            return false;
        }
        if (this.documentPage.buttonMerge.getSelection()) {
            return this.checkAndMergeQuantitationDocument();
        }
        return this.checkAndCreateNewQuantitationDocument();
    }

    private boolean checkAndMergeQuantitationDocument() {
        String name = this.documentPage.comboQuantitationCompoundNames.getText().trim();
        IQuantitationCompoundMSD quantitationCompoundMSD = this.database.getQuantitationCompound(name);
        if (quantitationCompoundMSD != null) {
            block5: {
                double concentration = this.decimalFormat.parse(this.documentPage.textConcentrationMerge.getText().trim()).doubleValue();
                if (!(concentration > 0.0)) break block5;
                String concentrationUnit = quantitationCompoundMSD.getConcentrationUnit();
                QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)this.chromatogramPeakMSD, concentration, concentrationUnit);
                this.database.getQuantitationPeaks(quantitationCompoundMSD).add(quantitationPeakMSD);
                return true;
            }
            try {
                this.showErrorMessage("Please select a valid concentration.");
            }
            catch (ParseException e) {
                logger.warn((Object)e);
                this.showErrorMessage("Please type in a valid concentration.");
            }
        } else {
            this.showErrorMessage("An existing quantitation compound must be selected.");
        }
        return false;
    }

    private boolean checkAndCreateNewQuantitationDocument() {
        String name = this.documentPage.comboPeakTargetNames.getText().trim();
        if (name == null || name.equals("")) {
            this.showErrorMessage("Please select a quantitation compound name.");
        } else {
            boolean documentStillExists = this.database.isQuantitationCompoundAlreadyAvailable(name);
            if (documentStillExists) {
                this.showErrorMessage("The quantitation compound still exists in the database.");
            } else {
                String concentrationUnit = this.documentPage.textConcentrationUnitCreate.getText().trim();
                if (concentrationUnit == null || concentrationUnit.equals("")) {
                    this.showErrorMessage("Please select a concentration unit.");
                } else {
                    block11: {
                        double concentration = this.decimalFormat.parse(this.documentPage.textConcentrationCreate.getText().trim()).doubleValue();
                        if (!(concentration > 0.0)) break block11;
                        int retentionTime = this.chromatogramPeakMSD.getPeakModel().getRetentionTimeAtPeakMaximum();
                        String chemicalClass = this.documentPage.textChemicalClassCreate.getText().trim();
                        QuantitationCompoundMSD quantitationCompoundMSD = new QuantitationCompoundMSD(name, concentrationUnit, retentionTime);
                        quantitationCompoundMSD.setChemicalClass(chemicalClass);
                        quantitationCompoundMSD.getRetentionTimeWindow().setAllowedNegativeDeviation(1500.0f);
                        quantitationCompoundMSD.getRetentionIndexWindow().setAllowedPositiveDeviation(1500.0f);
                        quantitationCompoundMSD.setUseTIC(true);
                        try {
                            QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)this.chromatogramPeakMSD, concentration, concentrationUnit);
                            this.database.addQuantitationCompound((IQuantitationCompoundMSD)quantitationCompoundMSD);
                            this.database.getQuantitationPeaks((IQuantitationCompoundMSD)quantitationCompoundMSD).add(quantitationPeakMSD);
                        }
                        catch (QuantitationCompoundAlreadyExistsException e) {
                            logger.warn((Object)e);
                        }
                        return true;
                    }
                    try {
                        this.showErrorMessage("Please select a valid concentration.");
                    }
                    catch (ParseException e1) {
                        logger.warn((Object)e1);
                        this.showErrorMessage("Please type in a valid concentration.");
                    }
                }
            }
        }
        return false;
    }

    private void showErrorMessage(String message) {
        this.documentPage.setErrorMessage(message);
    }

    private void removeErrorMessage() {
        this.documentPage.setErrorMessage(null);
    }

    private List<String> getPeakTargetNames(IChromatogramPeakMSD chromatogramPeakMSD) {
        List peakTargets;
        ArrayList<String> peakTargetNames = new ArrayList<String>();
        if (chromatogramPeakMSD != null && (peakTargets = chromatogramPeakMSD.getTargets()).size() > 0) {
            for (IPeakTarget peakTarget : peakTargets) {
                if (!(peakTarget instanceof IPeakTarget)) continue;
                IPeakTarget peakIdentificationEntry = peakTarget;
                String name = peakIdentificationEntry.getLibraryInformation().getName();
                peakTargetNames.add(name);
            }
        }
        return peakTargetNames;
    }
}

