/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.handlers;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.AddAllPeaksWizard;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class AddAllPeaksToQuantitationTableHandler
implements EventHandler {
    private static IChromatogramSelectionMSD chromatogramSelection;
    @Inject
    IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        List peaks;
        IChromatogramMSD chromatogram;
        PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.perspective", (String)"org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.views.QuantitationCompoundsView");
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogramMSD()) != null && (peaks = chromatogram.getPeaks(chromatogramSelection)) != null) {
            AddAllPeaksWizard wizard = new AddAllPeaksWizard(peaks);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: The peaks have been added to the quantitation table.");
                if (this.eventBroker != null) {
                    this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationtable", (Object)PreferenceSupplier.getSelectedQuantitationTable());
                }
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

