/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor;
import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.InteractiveChartExtended;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class ScorePlotPage {
    private Color COLOR_BLACK = Display.getCurrent().getSystemColor(2);
    private Color COLOR_WHITE = Display.getCurrent().getSystemColor(1);
    private Color COLOR_RED = Display.getCurrent().getSystemColor(3);
    private Color COLOR_BLUE = Display.getCurrent().getSystemColor(9);
    private Color COLOR_MAGENTA = Display.getCurrent().getSystemColor(11);
    private Color COLOR_CYAN = Display.getCurrent().getSystemColor(13);
    private Color COLOR_GRAY = Display.getCurrent().getSystemColor(15);
    private int SYMBOL_SIZE = 8;
    private PcaEditor pcaEditor;
    private InteractiveChartExtended scorePlotChart;
    private Spinner spinnerPCx;
    private Spinner spinnerPCy;

    public ScorePlotPage(PcaEditor pcaEditor, TabFolder tabFolder, FormToolkit formToolkit) {
        this.pcaEditor = pcaEditor;
        this.initialize(tabFolder, formToolkit);
    }

    public void update() {
        this.updateSpinnerPCMaxima();
        this.reloadScorePlotChart();
    }

    private void initialize(TabFolder tabFolder, FormToolkit formToolkit) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Score Plot");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)1808);
        Composite spinnerComposite = new Composite(parent, 0);
        spinnerComposite.setLayout((Layout)new GridLayout(5, false));
        spinnerComposite.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        gridData.heightHint = 20;
        Label label = new Label(spinnerComposite, 0);
        label.setText("PC X-Axis: ");
        this.spinnerPCx = new Spinner(spinnerComposite, 0);
        this.spinnerPCx.setMinimum(1);
        this.spinnerPCx.setMaximum(1);
        this.spinnerPCx.setIncrement(1);
        this.spinnerPCx.setLayoutData((Object)gridData);
        label = new Label(spinnerComposite, 0);
        label.setText(" PC Y-Axis: ");
        this.spinnerPCy = new Spinner(spinnerComposite, 0);
        this.spinnerPCy.setMinimum(1);
        this.spinnerPCy.setMaximum(1);
        this.spinnerPCy.setIncrement(1);
        this.spinnerPCy.setLayoutData((Object)gridData);
        Button button = new Button(spinnerComposite, 8);
        button.setText("Reload Score Plot");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScorePlotPage.this.reloadScorePlotChart();
            }
        });
        Composite chartComposite = new Composite(parent, 0);
        chartComposite.setLayout((Layout)new GridLayout(1, true));
        chartComposite.setLayoutData((Object)new GridData(1808));
        this.scorePlotChart = new InteractiveChartExtended(chartComposite, 0);
        this.scorePlotChart.setLayoutData((Object)new GridData(1808));
        this.scorePlotChart.getTitle().setText("PCA Score Plot");
        this.scorePlotChart.getTitle().setForeground(this.COLOR_BLACK);
        this.scorePlotChart.setBackground(this.COLOR_WHITE);
        this.scorePlotChart.getLegend().setVisible(false);
        this.scorePlotChart.getAxisSet().getXAxis(0).getTitle().setText("PC" + this.spinnerPCx.getSelection());
        this.scorePlotChart.getAxisSet().getXAxis(0).getTitle().setForeground(this.COLOR_BLACK);
        this.scorePlotChart.getAxisSet().getXAxis(0).getTick().setForeground(this.COLOR_BLACK);
        this.scorePlotChart.getAxisSet().getYAxis(0).getTitle().setText("PC" + this.spinnerPCy.getSelection());
        this.scorePlotChart.getAxisSet().getYAxis(0).getTitle().setForeground(this.COLOR_BLACK);
        this.scorePlotChart.getAxisSet().getYAxis(0).getTick().setForeground(this.COLOR_BLACK);
        IPlotArea plotArea = (IPlotArea)this.scorePlotChart.getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                Range xRange = ScorePlotPage.this.scorePlotChart.getAxisSet().getXAxes()[0].getRange();
                Range yRange = ScorePlotPage.this.scorePlotChart.getAxisSet().getYAxes()[0].getRange();
                if (xRange.lower < 0.0 && xRange.upper > 0.0 && yRange.lower < 0.0 && yRange.upper > 0.0) {
                    Rectangle rectangle = ScorePlotPage.this.scorePlotChart.getPlotArea().getClientArea();
                    int width = rectangle.width;
                    int height = rectangle.height;
                    double xDelta = xRange.upper - xRange.lower;
                    double yDelta = yRange.upper - yRange.lower;
                    double xDiff = xRange.lower * -1.0;
                    double yDiff = yRange.upper;
                    double xPart = 100.0 / xDelta * xDiff / 100.0;
                    double yPart = 100.0 / yDelta * yDiff / 100.0;
                    int xWidth = (int)((double)width * xPart);
                    int yHeight = (int)((double)height * yPart);
                    e.gc.setForeground(ScorePlotPage.this.COLOR_BLACK);
                    e.gc.drawLine(xWidth, 0, xWidth, height);
                    e.gc.drawLine(0, yHeight, width, yHeight);
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                ISeries[] series;
                ISeriesSet seriesSet = ScorePlotPage.this.scorePlotChart.getSeriesSet();
                ISeries[] iSeriesArray = series = seriesSet.getSeries();
                int n = series.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries serie = iSeriesArray[n2];
                    String label = serie.getId();
                    Point point = serie.getPixelCoordinates(0);
                    Point labelSize = e.gc.textExtent(label);
                    e.gc.setForeground(ScorePlotPage.this.COLOR_BLACK);
                    e.gc.drawText(label, (int)((double)point.x - (double)labelSize.x / 2.0), (int)((double)(point.y - labelSize.y) - (double)ScorePlotPage.this.SYMBOL_SIZE / 2.0), true);
                    ++n2;
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
        tabItem.setControl((Control)composite);
    }

    private void updateSpinnerPCMaxima() {
        IPcaResults pcaResults = this.pcaEditor.getPcaResults();
        if (pcaResults != null) {
            this.spinnerPCx.setMaximum(pcaResults.getNumberOfPrincipleComponents());
            this.spinnerPCx.setSelection(1);
            this.spinnerPCy.setMaximum(pcaResults.getNumberOfPrincipleComponents());
            this.spinnerPCy.setSelection(2);
        }
    }

    private void reloadScorePlotChart() {
        if (this.scorePlotChart != null) {
            IPcaResults pcaResults = this.pcaEditor.getPcaResults();
            ISeriesSet seriesSet = this.scorePlotChart.getSeriesSet();
            ISeries[] series = seriesSet.getSeries();
            ISeries[] iSeriesArray = series;
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                seriesSet.deleteSeries(serie.getId());
                ++n2;
            }
            String[] fileNames = new String[pcaResults.getPcaResultMap().entrySet().size()];
            int count = 0;
            for (Map.Entry entry : pcaResults.getPcaResultMap().entrySet()) {
                String name;
                fileNames[count] = name = ((ISample)entry.getKey()).getName();
                ILineSeries scatterSeries = (ILineSeries)this.scorePlotChart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, name);
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolSize(this.SYMBOL_SIZE);
                IPcaResult pcaResult = (IPcaResult)entry.getValue();
                double[] eigenSpace = pcaResult.getEigenSpace();
                int pcx = this.spinnerPCx.getSelection();
                int pcy = this.spinnerPCy.getSelection();
                this.scorePlotChart.getAxisSet().getXAxis(0).getTitle().setText("PC" + pcx);
                this.scorePlotChart.getAxisSet().getYAxis(0).getTitle().setText("PC" + pcy);
                double x = eigenSpace[pcx - 1];
                double y = eigenSpace[pcy - 1];
                scatterSeries.setXSeries(new double[]{x});
                scatterSeries.setYSeries(new double[]{y});
                if (x > 0.0 && y > 0.0) {
                    scatterSeries.setSymbolColor(this.COLOR_RED);
                    scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.SQUARE);
                    continue;
                }
                if (x > 0.0 && y < 0.0) {
                    scatterSeries.setSymbolColor(this.COLOR_BLUE);
                    scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.TRIANGLE);
                    continue;
                }
                if (x < 0.0 && y > 0.0) {
                    scatterSeries.setSymbolColor(this.COLOR_MAGENTA);
                    scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
                    continue;
                }
                if (x < 0.0 && y < 0.0) {
                    scatterSeries.setSymbolColor(this.COLOR_CYAN);
                    scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                    continue;
                }
                scatterSeries.setSymbolColor(this.COLOR_GRAY);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
            }
            this.scorePlotChart.getAxisSet().adjustRange();
            this.scorePlotChart.redraw();
            this.scorePlotChart.update();
        }
    }
}

