/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.detector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.detector.BackfoldingPeakDetectorSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.detector.IBackfoldingShifter;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.BackfoldingPeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.BackfoldingSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.IBackfoldingSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.Threshold;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.support.IBackfoldingDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorMSDSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ExtendedTotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.IProgressMonitor;

public class BackfoldingShifter
implements IBackfoldingShifter {
    private static final Logger logger = Logger.getLogger(BackfoldingShifter.class);
    private IBackfoldingSettings backfoldingSettings;

    @Override
    public IExtractedIonSignals shiftIons(IChromatogramSelectionMSD chromatogramSelection, IBackfoldingSettings backfoldingSettings, IProgressMonitor monitor) {
        IExtractedIonSignals extractedIonSignalsShifted = null;
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            extractedIonSignalsShifted = extractedIonSignalExtractor.getExtractedIonSignals(chromatogramSelection);
            if (backfoldingSettings == null) {
                backfoldingSettings = new BackfoldingSettings();
            }
            this.backfoldingSettings = backfoldingSettings;
            int runs = backfoldingSettings.getNumberOfBackfoldingRuns();
            int run = 1;
            while (run <= runs) {
                String taskDescription = "Shift scans run (" + run + "/" + runs + ")";
                monitor.subTask(taskDescription);
                extractedIonSignalsShifted = this.calculateExtractedIonSignals(extractedIonSignalsShifted, taskDescription, monitor);
                ++run;
            }
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        return extractedIonSignalsShifted;
    }

    private IExtractedIonSignals calculateExtractedIonSignals(IExtractedIonSignals extractedIonSignals, String taskDescription, IProgressMonitor monitor) {
        IExtractedIonSignals extractedIonSignalsShifted = extractedIonSignals.makeDeepCopyWithoutSignals();
        int startIon = extractedIonSignals.getStartIon();
        int stopIon = extractedIonSignals.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            monitor.subTask(String.valueOf(taskDescription) + " - ion: " + ion);
            ITotalScanSignals totalIonSignals = extractedIonSignals.getTotalIonSignals(ion);
            this.adjustIon(ion, totalIonSignals, extractedIonSignalsShifted);
            ++ion;
        }
        return extractedIonSignalsShifted;
    }

    private void adjustIon(int ion, ITotalScanSignals totalIonSignals, IExtractedIonSignals extractedIonSignalsShifted) {
        int startScan = extractedIonSignalsShifted.getStartScan();
        int stopScan = extractedIonSignalsShifted.getStopScan();
        IChromatogramMSD chromatogram = extractedIonSignalsShifted.getChromatogram();
        ITotalScanSignals totalIonSignalsShifted = this.calculateTotalIonSignalsShifted(totalIonSignals, chromatogram, startScan, stopScan);
        this.addShiftedIonSignalsToExtractedIonSignals(ion, totalIonSignalsShifted, extractedIonSignalsShifted);
    }

    private ITotalScanSignals calculateTotalIonSignalsShifted(ITotalScanSignals totalIonSignals, IChromatogramMSD chromatogram, int startScan, int stopScan) {
        ExtendedTotalScanSignal totalIonSignalShifted;
        float actualSignal;
        ITotalScanSignal totalIonSignal;
        TotalScanSignals totalIonSignalsShifted = new TotalScanSignals(startScan, stopScan, (IChromatogram)chromatogram);
        int scan = startScan;
        while (scan < stopScan) {
            totalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            actualSignal = totalIonSignal.getTotalSignal();
            float nextSignal = totalIonSignals.getNextTotalScanSignal(scan).getTotalSignal();
            float deltaSignal = nextSignal - actualSignal;
            totalIonSignalShifted = new ExtendedTotalScanSignal(totalIonSignal.getRetentionTime(), totalIonSignal.getRetentionIndex(), deltaSignal);
            totalIonSignalsShifted.add((ITotalScanSignal)totalIonSignalShifted);
            ++scan;
        }
        totalIonSignal = totalIonSignals.getTotalScanSignal(stopScan);
        actualSignal = totalIonSignal.getTotalSignal();
        totalIonSignalShifted = new ExtendedTotalScanSignal(totalIonSignal.getRetentionTime(), totalIonSignal.getRetentionIndex(), actualSignal);
        totalIonSignalsShifted.add((ITotalScanSignal)totalIonSignalShifted);
        return totalIonSignalsShifted;
    }

    private void addShiftedIonSignalsToExtractedIonSignals(int ion, ITotalScanSignals totalIonSignalsShifted, IExtractedIonSignals extractedIonSignalsShifted) {
        int retentionTime = 0;
        float abundance = 0.0f;
        int startScan = extractedIonSignalsShifted.getStartScan();
        int stopScan = extractedIonSignalsShifted.getStopScan();
        int deltaRetentionTime = this.calculateDeltaRetentionTimeShift(totalIonSignalsShifted);
        int scan = startScan;
        while (scan < stopScan) {
            ITotalScanSignal totalIonSignal = totalIonSignalsShifted.getTotalScanSignal(scan);
            retentionTime = totalIonSignal.getRetentionTime();
            retentionTime = totalIonSignal.getTotalSignal() >= 0.0f ? (retentionTime += deltaRetentionTime) : (retentionTime -= deltaRetentionTime);
            abundance = Math.abs(totalIonSignal.getTotalSignal());
            extractedIonSignalsShifted.add(ion, abundance, retentionTime, false);
            ++scan;
        }
    }

    private int calculateDeltaRetentionTimeShift(ITotalScanSignals totalIonSignalsShifted) {
        ITotalScanSignals totalIonSignalsNegative = this.getTotalIonSignalsNegative(totalIonSignalsShifted);
        ITotalScanSignals totalIonSignalsPositive = this.getTotalIonSignalsPositive(totalIonSignalsShifted);
        BackfoldingPeakDetectorSettings peakDetectorSettings = new BackfoldingPeakDetectorSettings();
        peakDetectorSettings.setThreshold(Threshold.OFF);
        List<IRawPeak> rawPeaksNegative = this.getRawPeaks(totalIonSignalsNegative, peakDetectorSettings);
        List<IRawPeak> rawPeaksPositive = this.getRawPeaks(totalIonSignalsPositive, peakDetectorSettings);
        int peaks = Math.min(rawPeaksNegative.size(), rawPeaksPositive.size());
        if (peaks == 0) {
            return 0;
        }
        NavigableMap<Integer, Integer> positiveTreeMap = this.getTreeMap(rawPeaksPositive);
        int[] deltaPeakDistances = this.calculateDeltaPeakDistances(peaks, rawPeaksNegative, positiveTreeMap);
        int result = Calculations.getMedian((int[])deltaPeakDistances);
        return result / 2;
    }

    private ITotalScanSignals getTotalIonSignalsNegative(ITotalScanSignals totalIonSignalsShifted) {
        ITotalScanSignals totalIonSignalsNegative = totalIonSignalsShifted.makeDeepCopy();
        totalIonSignalsNegative.setPositiveTotalSignalsToZero();
        totalIonSignalsNegative.setTotalSignalsAsAbsoluteValues();
        return totalIonSignalsNegative;
    }

    private ITotalScanSignals getTotalIonSignalsPositive(ITotalScanSignals totalIonSignalsShifted) {
        ITotalScanSignals totalIonSignalsPositive = totalIonSignalsShifted.makeDeepCopy();
        totalIonSignalsPositive.setNegativeTotalSignalsToZero();
        return totalIonSignalsPositive;
    }

    private List<IRawPeak> getRawPeaks(ITotalScanSignals totalIonSignals, IPeakDetectorMSDSettings peakDetectorSettings) {
        IBackfoldingDetectorSlopes slopes = BackfoldingPeakDetectorSupport.getBackfoldingSlopes(totalIonSignals, peakDetectorSettings);
        List<IRawPeak> rawPeaks = BackfoldingPeakDetectorSupport.getRawPeaks(slopes, peakDetectorSettings);
        return rawPeaks;
    }

    private NavigableMap<Integer, Integer> getTreeMap(List<IRawPeak> rawPeaks) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (IRawPeak rawPeak : rawPeaks) {
            treeMap.put(rawPeak.getMaximumScan(), rawPeak.getRetentionTimeAtMaximum());
        }
        return treeMap;
    }

    private int[] calculateDeltaPeakDistances(int peaks, List<IRawPeak> rawPeaksNegative, NavigableMap<Integer, Integer> positiveTreeMap) {
        int deltaDistance = 0;
        int negativeMaximum = 0;
        int positiveMaximum = 0;
        ArrayList<Integer> peakDistances = new ArrayList<Integer>();
        int maxDistance = this.backfoldingSettings.getMaximumRetentionTimeShift() * 2;
        int peak = 0;
        while (peak < peaks) {
            IRawPeak negativeRawPeak = rawPeaksNegative.get(peak);
            negativeMaximum = negativeRawPeak.getRetentionTimeAtMaximum();
            deltaDistance = Math.abs(negativeMaximum - (positiveMaximum = this.calculatePositiveMaximum(negativeRawPeak.getMaximumScan(), positiveTreeMap)));
            if (deltaDistance <= maxDistance) {
                peakDistances.add(deltaDistance);
            }
            ++peak;
        }
        int[] deltaPeakDistances = new int[peakDistances.size()];
        int counter = 0;
        for (Integer value : peakDistances) {
            deltaPeakDistances[counter++] = value;
        }
        return deltaPeakDistances;
    }

    private int calculatePositiveMaximum(int scan, NavigableMap<Integer, Integer> positiveTreeMap) {
        int result = 0;
        Map.Entry<Integer, Integer> positivePeak = positiveTreeMap.lowerEntry(scan);
        if (positivePeak != null) {
            result = positivePeak.getValue();
        }
        return result;
    }
}

