/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.swt.SwtRendererImpl;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public final class RegionAction {
    private final StructureSource _oSource;
    private Cursor cursor = null;
    private Region region;
    private final Action _ac;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    private RegionAction(StructureSource source, Region region, Action ac) {
        this._oSource = source;
        this._ac = ac;
        this.region = region;
    }

    RegionAction(StructureSource oSource, Location[] loa, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        int[] i2a = SwtRendererImpl.getCoordinatesAsInts(loa, 2, dTranslateX, dTranslateY, dScale);
        Region sh = new Region();
        sh.add(i2a);
        if (clipping != null) {
            sh.intersect(clipping);
        }
        this._ac = ac;
        this.region = sh;
    }

    RegionAction(StructureSource oSource, Bounds bo, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        bo = goFactory.copyOf(bo);
        bo.translate(dTranslateX, dTranslateY);
        bo.scale(dScale);
        Rectangle rect = new Rectangle((int)bo.getLeft(), (int)bo.getTop(), (int)bo.getWidth(), (int)bo.getHeight());
        Region sh = new Region();
        sh.add(rect);
        if (clipping != null) {
            sh.intersect(clipping);
        }
        this._ac = ac;
        this.region = sh;
    }

    private static final int toSwingArcType(int iArcStyle) {
        switch (iArcStyle) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    private int[] shape2polyCoords(Shape shape) {
        if (shape == null) {
            return null;
        }
        ArrayList<Integer> al = new ArrayList<Integer>();
        FlatteningPathIterator pitr = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        double[] data = new double[6];
        while (!pitr.isDone()) {
            int type = pitr.currentSegment(data);
            switch (type) {
                case 0: {
                    al.add((int)data[0]);
                    al.add((int)data[1]);
                    break;
                }
                case 1: {
                    al.add((int)data[0]);
                    al.add((int)data[1]);
                    break;
                }
                case 2: {
                    al.add((int)data[0]);
                    al.add((int)data[1]);
                    al.add((int)data[2]);
                    al.add((int)data[3]);
                    break;
                }
                case 3: {
                    al.add((int)data[0]);
                    al.add((int)data[1]);
                    al.add((int)data[2]);
                    al.add((int)data[3]);
                    al.add((int)data[4]);
                    al.add((int)data[5]);
                    break;
                }
            }
            pitr.next();
        }
        if (al.size() == 0) {
            return null;
        }
        int[] coords = new int[al.size()];
        int i = 0;
        while (i < al.size()) {
            coords[i] = (Integer)al.get(i);
            ++i;
        }
        return coords;
    }

    RegionAction(StructureSource oSource, Bounds boEllipse, double dStart, double dExtent, int iArcType, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        boEllipse = goFactory.copyOf(boEllipse);
        boEllipse.translate(dTranslateX, dTranslateY);
        boEllipse.scale(dScale);
        Arc2D.Double shape = new Arc2D.Double(boEllipse.getLeft(), boEllipse.getTop(), boEllipse.getWidth(), boEllipse.getHeight(), dStart, dExtent, RegionAction.toSwingArcType(iArcType));
        int[] i2a = this.shape2polyCoords(shape);
        Region sh = new Region();
        sh.add(i2a);
        if (clipping != null) {
            sh.intersect(clipping);
        }
        this._ac = ac;
        this.region = sh;
    }

    public final Action getAction() {
        return this._ac;
    }

    public final StructureSource getSource() {
        return this._oSource;
    }

    public RegionAction copy() {
        return new RegionAction(this._oSource, this.region, this._ac);
    }

    public boolean contains(Point p, GC gc) {
        return this.contains(p.x, p.y, gc);
    }

    public boolean contains(double x, double y, GC gc) {
        if (this.region != null) {
            return this.region.contains((int)x, (int)y);
        }
        return false;
    }

    public void dispose() {
        if (this.region != null) {
            this.region.dispose();
        }
    }

    public boolean isEmpty() {
        if (this.region != null) {
            return this.region.isEmpty();
        }
        return true;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }
}

