/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.AbstractChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.ChromatogramSelectionException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.ClassifierSettingsException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.processing.ChromatogramClassifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.classifier.processing.IChromatogramClassifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.IChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.processor.DurbinWatsonProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.result.DurbinWatsonClassifierResult;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.settings.IDurbinWatsonClassifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramResult;
import org.eclipse.chemclipse.model.implementation.ChromatogramResult;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class Classifier
extends AbstractChromatogramClassifier {
    private static final Logger logger = Logger.getLogger(Classifier.class);

    public IChromatogramClassifierProcessingInfo applyClassifier(IChromatogramSelectionMSD chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, IProgressMonitor monitor) {
        ChromatogramClassifierProcessingInfo processingInfo = new ChromatogramClassifierProcessingInfo();
        try {
            this.validate(chromatogramSelection, chromatogramClassifierSettings);
            IDurbinWatsonClassifierSettings classifierSettings = chromatogramClassifierSettings instanceof IDurbinWatsonClassifierSettings ? (IDurbinWatsonClassifierSettings)chromatogramClassifierSettings : PreferenceSupplier.getSettings();
            DurbinWatsonProcessor durbinWatsonProcessor = new DurbinWatsonProcessor();
            DurbinWatsonClassifierResult durbinWatsonClassifierResult = new DurbinWatsonClassifierResult(ResultStatus.OK, "The chromatogram has been classified.");
            durbinWatsonProcessor.run(chromatogramSelection, classifierSettings, durbinWatsonClassifierResult, monitor);
            ChromatogramResult chromatogramResult = new ChromatogramResult("org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson", "This is the Durbin-Watson classifier result.", (Object)durbinWatsonClassifierResult);
            chromatogramSelection.getChromatogram().addChromatogramResult((IChromatogramResult)chromatogramResult);
            processingInfo.setChromatogramClassifierResult((IChromatogramClassifierResult)durbinWatsonClassifierResult);
        }
        catch (ChromatogramSelectionException e1) {
            logger.warn((Object)e1);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Durbin-Watson Classifier", "The chromatogram selection is invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (ClassifierSettingsException e1) {
            logger.warn((Object)e1);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Durbin-Watson Classifier", "The settings are invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }

    public IChromatogramClassifierProcessingInfo applyClassifier(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IDurbinWatsonClassifierSettings chromatogramClassifierSettings = PreferenceSupplier.getSettings();
        return this.applyClassifier(chromatogramSelection, chromatogramClassifierSettings, monitor);
    }
}

