/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Set;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSetPropertyDecorator<S, E>
extends SetProperty<S, E>
implements IBeanSetProperty<S, E> {
    private final ISetProperty<S, E> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanSetPropertyDecorator(ISetProperty<S, E> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getElementType() {
        return this.delegate.getElementType();
    }

    public Class<E> getElementClass() {
        return this.delegate.getElementClass();
    }

    protected Set<E> doGetSet(S source) {
        return this.delegate.getSet(source);
    }

    protected void doSetSet(S source, Set<E> set) {
        this.delegate.setSet(source, set);
    }

    protected void doUpdateSet(S source, SetDiff<E> diff) {
        this.delegate.updateSet(source, diff);
    }

    @Override
    public <T> IBeanMapProperty<S, E, T> values(String propertyName) {
        return this.values(propertyName, null);
    }

    @Override
    public <T> IBeanMapProperty<S, E, T> values(String propertyName, Class<T> valueType) {
        Class beanClass = this.delegate.getElementClass();
        return this.values(BeanProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <T> IBeanMapProperty<S, E, T> values(IBeanValueProperty<E, T> property) {
        return new BeanMapPropertyDecorator(super.values(property), property.getPropertyDescriptor());
    }

    public IObservableSet<E> observe(S source) {
        return new BeanObservableSetDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableSet<E> observe(Realm realm, S source) {
        return new BeanObservableSetDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <M extends S> IObservableSet<E> observeDetail(IObservableValue<M> master) {
        return new BeanObservableSetDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

