/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakQuantitationEntriesLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IQuantitationEntry) {
            IQuantitationEntry quantitationEntry = (IQuantitationEntry)element;
            switch (columnIndex) {
                case 0: {
                    text = quantitationEntry.getName();
                    break;
                }
                case 1: {
                    text = quantitationEntry.getChemicalClass();
                    break;
                }
                case 2: {
                    text = decimalFormat.format(quantitationEntry.getConcentration());
                    break;
                }
                case 3: {
                    text = quantitationEntry.getConcentrationUnit();
                    break;
                }
                case 4: {
                    text = decimalFormat.format(quantitationEntry.getArea());
                    break;
                }
                case 5: {
                    text = quantitationEntry.getCalibrationMethod();
                    break;
                }
                case 6: {
                    text = Boolean.toString(quantitationEntry.getUsedCrossZero());
                    break;
                }
                case 7: {
                    text = quantitationEntry.getDescription();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("integrationResults.gif", "16x16");
    }
}

