/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components.chromatogram;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.IAxisTick;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class ChromatogramOverviewUI
extends Chart {
    private DecimalFormat decimalFormat = new DecimalFormat();

    public ChromatogramOverviewUI(Composite parent, int style) {
        super(parent, style);
        this.decimalFormat.setMaximumFractionDigits(0);
        this.decimalFormat.setMaximumIntegerDigits(0);
        this.initialize();
    }

    public void showChromatogramOverview(IChromatogramOverview chromatogramOverview) {
        if (chromatogramOverview != null) {
            this.setChromatogramOverview(chromatogramOverview);
        }
    }

    private void initialize() {
        this.setBackground(Colors.WHITE);
        this.setBackgroundInPlotArea(Colors.WHITE);
        this.getLegend().setVisible(false);
        this.getTitle().setVisible(false);
        IAxisTick xAxisTick = this.getAxisSet().getXAxis(0).getTick();
        IAxisTick yAxisTick = this.getAxisSet().getYAxis(0).getTick();
        this.getAxisSet().getXAxis(0).getTitle().setVisible(false);
        xAxisTick.setVisible(false);
        xAxisTick.setForeground(Colors.BLACK);
        this.getAxisSet().getYAxis(0).getTitle().setVisible(false);
        yAxisTick.setVisible(false);
        yAxisTick.setFormat((Format)this.decimalFormat);
        yAxisTick.setForeground(Colors.BLACK);
        this.getAxisSet().adjustRange();
    }

    private void setChromatogramOverview(IChromatogramOverview chromatogramOverview) {
        this.deleteAllCurrentSeries();
        org.eclipse.chemclipse.swt.ui.series.ISeries series = SeriesConverter.convertChromatogramOverview(chromatogramOverview, Sign.POSITIVE, false);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(series.getId()) + "+");
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.RED);
        IAxisSet axisSet = this.getAxisSet();
        IAxis milliseconds = axisSet.getXAxis(0);
        milliseconds.getTick().setVisible(false);
        milliseconds.getTitle().setVisible(false);
        IAxis abundance = axisSet.getYAxis(0);
        abundance.getTick().setVisible(false);
        abundance.getTick().setFormat((Format)this.decimalFormat);
        abundance.getTitle().setVisible(false);
        this.getAxisSet().adjustRange();
        this.getPlotArea().redraw();
    }

    private void deleteAllCurrentSeries() {
        ISeries[] series = this.getSeriesSet().getSeries();
        ArrayList<String> ids = new ArrayList<String>();
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries serie = iSeriesArray[n2];
            ids.add(serie.getId());
            ++n2;
        }
        for (String id : ids) {
            this.getSeriesSet().deleteSeries(id);
        }
    }
}

