/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.BackgroundIntegrator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.ChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.ISumareaIntegrator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.support.ISumareaChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.settings.ISumareaIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ChromatogramIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public class SumareaChromatogramIntegratorSupport
implements ISumareaChromatogramIntegratorSupport {
    private static final Logger logger = Logger.getLogger(SumareaChromatogramIntegratorSupport.class);
    public static String INTEGRATOR_DESCRIPTION = "SumArea Integrator";

    @Override
    public IChromatogramIntegrationResults calculateChromatogramIntegrationResults(IChromatogramSelectionMSD chromatogramSelection, IChromatogramIntegrationSettings chromatogramIntegrationSettings, IProgressMonitor monitor) {
        boolean integrateAll = false;
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals(chromatogramSelection);
            int startIon = extractedIonSignals.getStartIon();
            int stopIon = extractedIonSignals.getStopIon();
            ChromatogramIntegrationResults chromatogramIntegrationResults = new ChromatogramIntegrationResults();
            IMarkedIons selectedIons = this.getSelectedIons(chromatogramIntegrationSettings);
            Set selectedIonsNominal = selectedIons.getIonsNominal();
            if (selectedIonsNominal.size() == 0 || selectedIonsNominal.contains(0)) {
                integrateAll = true;
            }
            ChromatogramIntegrator chromatogramIntegrator = new ChromatogramIntegrator();
            BackgroundIntegrator backgroundIntegrator = new BackgroundIntegrator();
            ArrayList<IIntegrationEntry> chromatogramIntegrationEntries = new ArrayList<IIntegrationEntry>();
            ArrayList<IIntegrationEntry> backgroundIntegrationEntries = new ArrayList<IIntegrationEntry>();
            int ion = startIon;
            while (ion <= stopIon) {
                monitor.subTask("Integrate the chromatogram area of ion: " + ion);
                if (integrateAll) {
                    this.calculateIntegrationResults(ion, chromatogramIntegrator, backgroundIntegrator, chromatogramSelection, chromatogramIntegrationEntries, backgroundIntegrationEntries, (IChromatogramIntegrationResults)chromatogramIntegrationResults);
                } else if (selectedIonsNominal.contains(ion)) {
                    this.calculateIntegrationResults(ion, chromatogramIntegrator, backgroundIntegrator, chromatogramSelection, chromatogramIntegrationEntries, backgroundIntegrationEntries, (IChromatogramIntegrationResults)chromatogramIntegrationResults);
                }
                ++ion;
            }
            chromatogram.setChromatogramIntegratedArea(chromatogramIntegrationEntries, INTEGRATOR_DESCRIPTION);
            chromatogram.setBackgroundIntegratedArea(backgroundIntegrationEntries, INTEGRATOR_DESCRIPTION);
            return chromatogramIntegrationResults;
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
            return null;
        }
    }

    private void calculateIntegrationResults(int ion, ISumareaIntegrator chromatogramIntegrator, ISumareaIntegrator backgroundIntegrator, IChromatogramSelectionMSD chromatogramSelection, List<IIntegrationEntry> chromatogramIntegrationEntries, List<IIntegrationEntry> backgroundIntegrationEntries, IChromatogramIntegrationResults chromatogramIntegrationResults) {
        IIntegrationEntryMSD chromatogramIntegrationEntry = this.calculateChromatogramIonArea(ion, chromatogramIntegrator, chromatogramSelection);
        IIntegrationEntryMSD backgroundIntegrationEntry = this.calculateBackgroundIonArea(ion, backgroundIntegrator, chromatogramSelection);
        chromatogramIntegrationEntries.add((IIntegrationEntry)chromatogramIntegrationEntry);
        backgroundIntegrationEntries.add((IIntegrationEntry)backgroundIntegrationEntry);
        this.setIntegrationResult(ion, chromatogramIntegrationResults, chromatogramIntegrationEntry.getIntegratedArea(), backgroundIntegrationEntry.getIntegratedArea());
    }

    private void setIntegrationResult(int ion, IChromatogramIntegrationResults chromatogramIntegrationResults, double chromatogramArea, double backgroundArea) {
        ChromatogramIntegrationResult chromatogramIntegrationResult = new ChromatogramIntegrationResult((double)ion, chromatogramArea, backgroundArea);
        chromatogramIntegrationResults.add((IChromatogramIntegrationResult)chromatogramIntegrationResult);
    }

    private IIntegrationEntryMSD calculateChromatogramIonArea(int ion, ISumareaIntegrator chromatogramIntegrator, IChromatogramSelectionMSD chromatogramSelection) {
        double chromatogramArea = chromatogramIntegrator.integrate(chromatogramSelection, ion);
        IntegrationEntryMSD chromatogramIntegrationEntry = new IntegrationEntryMSD((double)ion, chromatogramArea);
        return chromatogramIntegrationEntry;
    }

    private IIntegrationEntryMSD calculateBackgroundIonArea(int ion, ISumareaIntegrator backgroundIntegrator, IChromatogramSelectionMSD chromatogramSelection) {
        double backgroundArea = backgroundIntegrator.integrate(chromatogramSelection, ion);
        IntegrationEntryMSD backgroundIntegrationEntry = new IntegrationEntryMSD((double)ion, backgroundArea);
        return backgroundIntegrationEntry;
    }

    private IMarkedIons getSelectedIons(IChromatogramIntegrationSettings chromatogramIntegrationSettings) {
        Object selectedIons = chromatogramIntegrationSettings instanceof ISumareaIntegrationSettings ? ((ISumareaIntegrationSettings)chromatogramIntegrationSettings).getSelectedIons() : new MarkedIons();
        return selectedIons;
    }
}

