/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.stream.XMLStreamException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.BatchProcessJobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BatchProcessExportRunnable
implements IRunnableWithProgress {
    private File file;
    private IBatchProcessJob batchProcessJob;

    public BatchProcessExportRunnable(File file, IBatchProcessJob batchProcessJob) {
        this.file = file;
        this.batchProcessJob = batchProcessJob;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        BatchProcessJobWriter writer = new BatchProcessJobWriter();
        try {
            writer.writeBatchProcessJob(this.file, this.batchProcessJob, monitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InterruptedException("The file " + this.file.getPath() + " couldn't be found.");
        }
        catch (FileIsNotWriteableException fileIsNotWriteableException) {
            throw new InterruptedException("The file " + this.file.getPath() + " is not writable.");
        }
        catch (IOException iOException) {
            throw new InterruptedException("The file " + this.file.getPath() + " makes problems.");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new InterruptedException("There is a problem writing the file " + this.file.getPath());
        }
    }
}

