/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.graphics.Image;

public class PeakListLabelProvider
extends AbstractChemClipseLabelProvider {
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IPeak) {
                IPeak peak = (IPeak)element;
                if (peak.isActiveForAnalysis()) {
                    return ApplicationImageFactory.getInstance().getImage("selected.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("deselected.gif", "16x16");
            }
        } else if (columnIndex == 1) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IPeakMSD) {
            IPeakMSD peak = (IPeakMSD)element;
            IPeakModelMSD peakModel = peak.getPeakModel();
            ILibraryInformation libraryInformation = this.getLibraryInformation(peak.getTargets());
            switch (columnIndex) {
                case 0: {
                    text = "";
                    break;
                }
                case 1: {
                    text = decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0);
                    break;
                }
                case 2: {
                    if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                        text = Integer.toString((int)peakModel.getPeakMassSpectrum().getRetentionIndex());
                        break;
                    }
                    text = decimalFormat.format(peakModel.getPeakMassSpectrum().getRetentionIndex());
                    break;
                }
                case 3: {
                    if (PreferenceSupplier.showAreaWithoutDecimals()) {
                        text = Integer.toString((int)peak.getIntegratedArea());
                        break;
                    }
                    text = decimalFormat.format(peak.getIntegratedArea());
                    break;
                }
                case 4: {
                    text = decimalFormat.format((double)peakModel.getStartRetentionTime() / 60000.0);
                    break;
                }
                case 5: {
                    text = decimalFormat.format((double)peakModel.getStopRetentionTime() / 60000.0);
                    break;
                }
                case 6: {
                    text = decimalFormat.format((double)peakModel.getWidthByInflectionPoints() / 60000.0);
                    break;
                }
                case 7: 
                case 8: {
                    if (!(element instanceof IChromatogramPeakMSD)) break;
                    IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)element;
                    switch (columnIndex) {
                        case 7: {
                            text = Integer.toString(chromatogramPeak.getScanMax());
                            break;
                        }
                        case 8: {
                            text = decimalFormat.format(chromatogramPeak.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                case 9: {
                    text = decimalFormat.format(peakModel.getLeading());
                    break;
                }
                case 10: {
                    text = decimalFormat.format(peakModel.getTailing());
                    break;
                }
                case 11: {
                    text = peak.getModelDescription();
                    break;
                }
                case 12: {
                    text = Integer.toString(peak.getSuggestedNumberOfComponents());
                    break;
                }
                case 13: {
                    if (libraryInformation == null) break;
                    text = libraryInformation.getName();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("peak.gif", "16x16");
    }

    private ILibraryInformation getLibraryInformation(List<IPeakTarget> targets) {
        ILibraryInformation libraryInformation = null;
        Collections.sort(targets, this.targetExtendedComparator);
        if (targets.size() >= 1) {
            libraryInformation = targets.get(0).getLibraryInformation();
        }
        return libraryInformation;
    }
}

