/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.ScanMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScanMassSpectrumCycleNumberUIWithLabel
extends Composite
implements IChromatogramSelectionMSDUpdateNotifier {
    private ScanMassSpectrumUI massSpectrumUI;
    private Label label;
    private Button buttonPreviousScan;
    private Button buttonNextScan;
    private IScanMSD massSpectrum;
    private int selectedIndex;
    private List<IScan> scanCycleScans;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private MassValueDisplayPrecision massValueDisplayPrecision;

    public ScanMassSpectrumCycleNumberUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite labelbar = new Composite(composite, 4);
        labelbar.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        labelbar.setLayoutData((Object)gridData);
        this.label = new Label(labelbar, 0);
        this.label.setText("");
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.label.setLayoutData((Object)gridData);
        this.buttonPreviousScan = new Button(labelbar, 8);
        this.buttonPreviousScan.setText("Previous Scan");
        this.buttonPreviousScan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScanMassSpectrumCycleNumberUIWithLabel scanMassSpectrumCycleNumberUIWithLabel = ScanMassSpectrumCycleNumberUIWithLabel.this;
                scanMassSpectrumCycleNumberUIWithLabel.selectedIndex = scanMassSpectrumCycleNumberUIWithLabel.selectedIndex - 1;
                if (ScanMassSpectrumCycleNumberUIWithLabel.this.selectedIndex < 0) {
                    ScanMassSpectrumCycleNumberUIWithLabel.this.selectedIndex = 0;
                }
                ScanMassSpectrumCycleNumberUIWithLabel.this.updateButtonsAndSetCycleScan(ScanMassSpectrumCycleNumberUIWithLabel.this.selectedIndex);
            }
        });
        this.buttonNextScan = new Button(labelbar, 8);
        this.buttonNextScan.setText("Next Scan");
        this.buttonNextScan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScanMassSpectrumCycleNumberUIWithLabel scanMassSpectrumCycleNumberUIWithLabel = ScanMassSpectrumCycleNumberUIWithLabel.this;
                scanMassSpectrumCycleNumberUIWithLabel.selectedIndex = scanMassSpectrumCycleNumberUIWithLabel.selectedIndex + 1;
                if (ScanMassSpectrumCycleNumberUIWithLabel.this.scanCycleScans != null && ScanMassSpectrumCycleNumberUIWithLabel.this.selectedIndex >= ScanMassSpectrumCycleNumberUIWithLabel.this.scanCycleScans.size()) {
                    ScanMassSpectrumCycleNumberUIWithLabel.this.selectedIndex = ScanMassSpectrumCycleNumberUIWithLabel.this.scanCycleScans.size() - 1;
                }
                ScanMassSpectrumCycleNumberUIWithLabel.this.updateButtonsAndSetCycleScan(ScanMassSpectrumCycleNumberUIWithLabel.this.selectedIndex);
            }
        });
        this.massSpectrumUI = new ScanMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.massSpectrumUI.setLayoutData(gridData);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null && this.massSpectrum != chromatogramSelection.getSelectedScan()) {
            this.massSpectrum = chromatogramSelection.getSelectedScan();
            int cycleNumber = this.massSpectrum.getCycleNumber();
            this.scanCycleScans = chromatogramSelection.getChromatogram().getScanCycleScans(cycleNumber);
            this.selectedIndex = 0;
            this.updateButtonsAndSetCycleScan(this.selectedIndex);
        }
    }

    private void updateButtonsAndSetCycleScan(int selectedIndex) {
        if (this.scanCycleScans != null) {
            if (this.scanCycleScans.size() <= 1) {
                this.buttonPreviousScan.setEnabled(false);
                this.buttonNextScan.setEnabled(false);
            } else if (selectedIndex == 0) {
                this.buttonPreviousScan.setEnabled(false);
                this.buttonNextScan.setEnabled(true);
            } else if (selectedIndex == this.scanCycleScans.size() - 1) {
                this.buttonPreviousScan.setEnabled(true);
                this.buttonNextScan.setEnabled(false);
            } else {
                this.buttonPreviousScan.setEnabled(true);
                this.buttonNextScan.setEnabled(true);
            }
            this.setSelectedScanCycleScan(selectedIndex);
        }
    }

    private void setSelectedScanCycleScan(int selectedIndex) {
        IScan scan;
        if (this.scanCycleScans != null && selectedIndex >= 0 && selectedIndex < this.scanCycleScans.size() && (scan = this.scanCycleScans.get(selectedIndex)) instanceof IScanMSD) {
            IScanMSD massSpectrumScanCycle = (IScanMSD)scan;
            this.setMassSpectrumLabel(massSpectrumScanCycle, selectedIndex + 1, this.scanCycleScans.size());
            this.massSpectrumUI.update(massSpectrumScanCycle, true);
        }
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum, int selectedScan, int sizeCycleNumberScans) {
        StringBuilder builder = new StringBuilder();
        builder.append("Cycle Number: ");
        builder.append(massSpectrum.getCycleNumber());
        builder.append(" | ");
        builder.append("Scan: ");
        builder.append(massSpectrum.getScanNumber());
        builder.append(" | ");
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("Signal: ");
        builder.append(this.decimalFormat.format(massSpectrum.getTotalSignal()));
        builder.append(" | ");
        builder.append("Time Segment Id: ");
        builder.append(massSpectrum.getTimeSegmentId());
        builder.append(" | ");
        builder.append("Cyle (");
        builder.append(selectedScan);
        builder.append("/");
        builder.append(sizeCycleNumberScans);
        builder.append(")");
        this.label.setText(builder.toString());
    }
}

